/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.ProtocolV1Authenticator;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.Map;

public class PlainTextAuthProvider
implements AuthProvider {
    private final String username;
    private final String password;

    public PlainTextAuthProvider(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Authenticator newAuthenticator(InetAddress host) {
        return new PlainTextAuthenticator(this.username, this.password);
    }

    private static class PlainTextAuthenticator
    extends ProtocolV1Authenticator
    implements Authenticator {
        private final byte[] username;
        private final byte[] password;

        public PlainTextAuthenticator(String username, String password) {
            this.username = username.getBytes(Charsets.UTF_8);
            this.password = password.getBytes(Charsets.UTF_8);
        }

        @Override
        public byte[] initialResponse() {
            byte[] initialToken = new byte[this.username.length + this.password.length + 2];
            initialToken[0] = 0;
            System.arraycopy(this.username, 0, initialToken, 1, this.username.length);
            initialToken[this.username.length + 1] = 0;
            System.arraycopy(this.password, 0, initialToken, this.username.length + 2, this.password.length);
            return initialToken;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) {
            return null;
        }

        @Override
        public void onAuthenticationSuccess(byte[] token) {
        }

        @Override
        Map<String, String> getCredentials() {
            return ImmutableMap.of((Object)"username", (Object)new String(this.username, Charsets.UTF_8), (Object)"password", (Object)new String(this.password, Charsets.UTF_8));
        }
    }
}

