/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ReplicationStrategy {
    ReplicationStrategy() {
    }

    static ReplicationStrategy create(Map<String, String> replicationOptions) {
        String strategyClass = replicationOptions.get("class");
        if (strategyClass == null) {
            return null;
        }
        try {
            if (strategyClass.contains("SimpleStrategy")) {
                String repFactorString = replicationOptions.get("replication_factor");
                return repFactorString == null ? null : new SimpleStrategy(Integer.parseInt(repFactorString));
            }
            if (strategyClass.contains("NetworkTopologyStrategy")) {
                HashMap<String, Integer> dcRfs = new HashMap<String, Integer>();
                for (Map.Entry<String, String> entry : replicationOptions.entrySet()) {
                    if (entry.getKey().equals("class")) continue;
                    dcRfs.put(entry.getKey(), Integer.parseInt(entry.getValue()));
                }
                return new NetworkTopologyStrategy(dcRfs);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    abstract Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> var1, List<Token> var2);

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }

    static class NetworkTopologyStrategy
    extends ReplicationStrategy {
        private final Map<String, Integer> replicationFactors;

        private NetworkTopologyStrategy(Map<String, Integer> replicationFactors) {
            this.replicationFactors = replicationFactors;
        }

        @Override
        Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> tokenToPrimary, List<Token> ring) {
            Map<String, Set<String>> racks = this.getRacksInDcs(tokenToPrimary.values());
            HashMap<Token, Set<Host>> replicaMap = new HashMap<Token, Set<Host>>(tokenToPrimary.size());
            for (int i = 0; i < ring.size(); ++i) {
                HashMap<String, Set<Host>> allDcReplicas = new HashMap<String, Set<Host>>();
                HashMap seenRacks = new HashMap();
                HashMap skippedDcEndpoints = new HashMap();
                for (String dc : this.replicationFactors.keySet()) {
                    allDcReplicas.put(dc, new HashSet());
                    seenRacks.put(dc, new HashSet());
                    skippedDcEndpoints.put(dc, new LinkedHashSet());
                }
                LinkedHashSet<Host> replicas = new LinkedHashSet<Host>();
                for (int j = 0; j < ring.size() && !this.allDone(allDcReplicas); ++j) {
                    Host h = tokenToPrimary.get(ReplicationStrategy.getTokenWrapping(i + j, ring));
                    String dc = h.getDatacenter();
                    if (dc == null || !allDcReplicas.containsKey(dc)) continue;
                    Integer rf = this.replicationFactors.get(dc);
                    Set dcReplicas = (Set)allDcReplicas.get(dc);
                    if (rf == null || dcReplicas.size() >= rf) continue;
                    String rack = h.getRack();
                    if (rack == null || ((Set)seenRacks.get(dc)).size() == racks.get(dc).size()) {
                        replicas.add(h);
                        dcReplicas.add(h);
                        continue;
                    }
                    if (((Set)seenRacks.get(dc)).contains(rack)) {
                        ((Set)skippedDcEndpoints.get(dc)).add(h);
                        continue;
                    }
                    replicas.add(h);
                    dcReplicas.add(h);
                    ((Set)seenRacks.get(dc)).add(rack);
                    if (((Set)seenRacks.get(dc)).size() != racks.get(dc).size()) continue;
                    Iterator skippedIt = ((Set)skippedDcEndpoints.get(dc)).iterator();
                    while (skippedIt.hasNext() && dcReplicas.size() < rf) {
                        Host nextSkipped = (Host)skippedIt.next();
                        replicas.add(nextSkipped);
                        dcReplicas.add(nextSkipped);
                    }
                }
                replicaMap.put(ring.get(i), (Set<Host>)ImmutableSet.copyOf(replicas));
            }
            return replicaMap;
        }

        private boolean allDone(Map<String, Set<Host>> map) {
            for (Map.Entry<String, Set<Host>> entry : map.entrySet()) {
                if (entry.getValue().size() >= this.replicationFactors.get(entry.getKey())) continue;
                return false;
            }
            return true;
        }

        private Map<String, Set<String>> getRacksInDcs(Iterable<Host> hosts) {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            for (Host host : hosts) {
                HashSet<String> racks = (HashSet<String>)result.get(host.getDatacenter());
                if (racks == null) {
                    racks = new HashSet<String>();
                    result.put(host.getDatacenter(), racks);
                }
                racks.add(host.getRack());
            }
            return result;
        }
    }

    static class SimpleStrategy
    extends ReplicationStrategy {
        private final int replicationFactor;

        private SimpleStrategy(int replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> tokenToPrimary, List<Token> ring) {
            int rf = Math.min(this.replicationFactor, ring.size());
            HashMap<Token, Set<Host>> replicaMap = new HashMap<Token, Set<Host>>(tokenToPrimary.size());
            for (int i = 0; i < ring.size(); ++i) {
                LinkedHashSet<Host> replicas = new LinkedHashSet<Host>();
                for (int j = 0; j < ring.size() && replicas.size() < rf; ++j) {
                    replicas.add(tokenToPrimary.get(ReplicationStrategy.getTokenWrapping(i + j, ring)));
                }
                replicaMap.put(ring.get(i), (Set<Host>)ImmutableSet.copyOf(replicas));
            }
            return replicaMap;
        }
    }
}

