/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.rhq.metrics;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.common.util.Strings;
import io.fabric8.insight.metrics.model.MBeanAttrResult;
import io.fabric8.insight.metrics.model.MBeanAttrsResult;
import io.fabric8.insight.metrics.model.MBeanOperResult;
import io.fabric8.insight.metrics.model.MBeanOpersResult;
import io.fabric8.insight.metrics.model.Metrics;
import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.model.Request;
import io.fabric8.insight.metrics.model.Result;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.rhq.metrics.RHQMetrics;
import org.rhq.metrics.core.RawNumericMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.insight.rhq.metrics", label="Fabric8 RHQ Metrics Storage", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={MetricsStorageService.class})
public class RhqMetricsStorage
extends AbstractComponent
implements MetricsStorageService {
    private static final transient Logger LOG = LoggerFactory.getLogger(RhqMetricsStorage.class);
    @Reference
    private Configurer configurer;
    private RHQMetrics metricsService;
    @Property(name="nodes", label="Cassandra Nodes", description="The host names or IP addresses of the cassandra nodes", cardinality=0x7FFFFFFF)
    private String[] nodes;
    @Property(name="keyspace", label="Cassandra Keyspace", description="The Cassandra Keyspace (schema)", value={"rhq"})
    private String keyspace;
    @Property(name="cqlport", label="Cassandra CQL Port", description="The port number to communicate with a Cassandra host to perform SQL statements", intValue={9042})
    private int cqlport;

    @Activate
    void activate(Map<String, String> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, String> configuration) throws Exception {
        this.updateConfiguration(configuration);
    }

    @Deactivate
    void deactivate() throws MBeanRegistrationException, InstanceNotFoundException {
        this.deactivateComponent();
        this.shutdownMetricService();
    }

    protected void updateConfiguration(Map<String, String> configuration) throws Exception {
        this.shutdownMetricService();
        this.metricsService = this.createMetricService(configuration);
        LOG.info("Created metrics service " + this.metricsService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownMetricService() {
        if (this.metricsService != null) {
            try {
                LOG.info("Shutting down metrics service " + this.metricsService);
                this.metricsService.shutdown();
            }
            finally {
                this.metricsService = null;
            }
        }
    }

    protected RHQMetrics createMetricService(Map<String, String> configuration) throws Exception {
        LOG.info("Configuring RHQ metric service from " + configuration);
        this.configurer.configure(configuration, (Object)this);
        RHQMetrics.Builder builder = new RHQMetrics.Builder();
        if (this.nodes != null && this.nodes.length > 0) {
            builder = builder.withCassandraDataStore();
            LOG.info("Using Cassandra nodes: " + Arrays.asList(this.nodes));
            builder.withNodes(this.nodes);
            if (Strings.isNotBlank((String)this.keyspace)) {
                builder.withKeyspace(this.keyspace);
            }
            if (this.cqlport > 0) {
                builder.withCQLPort(this.cqlport);
            }
        } else {
            builder = builder.withInMemoryDataStore();
        }
        return builder.build();
    }

    public void store(String type, long timestamp, QueryResult queryResult) {
        this.assertValid();
        if (this.metricsService == null) {
            throw new IllegalStateException("No metricsService available!");
        }
        Map results = queryResult.getResults();
        if (results != null) {
            HashSet<RawNumericMetric> data = new HashSet<RawNumericMetric>();
            Set entries = results.entrySet();
            for (Map.Entry entry : entries) {
                MBeanAttrsResult attrsResult;
                List attrResults;
                String key = (String)entry.getKey();
                Result result = (Result)entry.getValue();
                if (result instanceof MBeanOpersResult) {
                    MBeanOpersResult opersResult = (MBeanOpersResult)result;
                    List operResults = opersResult.getResults();
                    if (operResults == null) continue;
                    for (MBeanOperResult operResult : operResults) {
                        Object value = operResult.getValue();
                        Double doubleValue = this.toDouble(value);
                        if (doubleValue == null) continue;
                        String id = Metrics.metricId((String)type, (Request)opersResult.getRequest());
                        data.add(new RawNumericMetric(id, doubleValue, timestamp));
                    }
                    continue;
                }
                if (!(result instanceof MBeanAttrsResult) || (attrResults = (attrsResult = (MBeanAttrsResult)result).getResults()) == null) continue;
                for (MBeanAttrResult attrResult : attrResults) {
                    Map attrs = attrResult.getAttrs();
                    if (attrs == null) continue;
                    Set attrEntries = attrs.entrySet();
                    for (Map.Entry attrEntry : attrEntries) {
                        String attributeName = (String)attrEntry.getKey();
                        Object value = attrEntry.getValue();
                        Double doubleValue = this.toDouble(value);
                        if (doubleValue == null) continue;
                        String id = Metrics.metricId((String)type, (Request)attrsResult.getRequest(), (String)attributeName);
                        data.add(new RawNumericMetric(id, doubleValue, timestamp));
                    }
                }
            }
            if (!data.isEmpty()) {
                this.metricsService.addData(data);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added " + data.size() + " metrics");
                }
            }
        }
    }

    protected Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return null;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

