/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.RawNumericMetric;
import org.rhq.metrics.impl.cassandra.MetricsServiceCassandra;
import org.rhq.metrics.impl.memory.MemoryMetricsService;

public class RHQMetrics {
    private MetricsService metricsService;

    private RHQMetrics(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public ListenableFuture<Void> addData(RawNumericMetric data) {
        return this.metricsService.addData(data);
    }

    public ListenableFuture<Map<RawNumericMetric, Throwable>> addData(Set<RawNumericMetric> data) {
        return this.metricsService.addData(data);
    }

    public ListenableFuture<List<RawNumericMetric>> findData(String id, long start, long end) {
        return this.metricsService.findData(id, start, end);
    }

    public void shutdown() {
        this.metricsService.shutdown();
    }

    public static class Builder {
        private boolean usingCassandra;
        private Map<String, String> options = new HashMap<String, String>();

        public Builder() {
            this.options.put("cqlport", "9042");
            this.options.put("nodes", "127.0.0.1");
            this.options.put("keyspace", "rhq-metrics");
        }

        public Builder withInMemoryDataStore() {
            this.usingCassandra = false;
            return this;
        }

        public Builder withCassandraDataStore() {
            this.usingCassandra = true;
            return this;
        }

        public Builder withCQLPort(int port) {
            this.options.put("cqlport", Integer.toString(port));
            return this;
        }

        public Builder withKeyspace(String keyspace) {
            this.options.put("keyspace", keyspace);
            return this;
        }

        public Builder withNodes(String ... nodes) {
            StringBuilder buffer = new StringBuilder();
            for (String node : nodes) {
                buffer.append(node).append(",");
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            return this;
        }

        public RHQMetrics build() {
            MetricsService metricsService = this.usingCassandra ? new MetricsServiceCassandra() : new MemoryMetricsService();
            metricsService.startUp(this.options);
            return new RHQMetrics(metricsService);
        }
    }
}

