/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.rhq.metrics.core.Counter;

public class DataAccess {
    private PreparedStatement insertData;
    private PreparedStatement findData;
    private PreparedStatement updateCounter;
    private PreparedStatement findCountersByGroup;
    private PreparedStatement findCountersByGroupAndName;
    private Session session;

    public DataAccess(Session session) {
        this.session = session;
        this.initPreparedStatements();
    }

    private void initPreparedStatements() {
        this.insertData = this.session.prepare("INSERT INTO metrics (bucket, metric_id, time, value) VALUES (?, ?, ?, ?) USING TTL ?");
        this.findData = this.session.prepare("SELECT metric_id, time, value FROM metrics WHERE bucket = ? AND metric_id = ? AND time >=? AND time < ?");
        this.updateCounter = this.session.prepare("UPDATE counters SET c_value = c_value + ? WHERE group = ? AND c_name = ?");
        this.findCountersByGroup = this.session.prepare("SELECT group, c_name, c_value FROM counters WHERE group = ?");
        this.findCountersByGroupAndName = this.session.prepare("SELECT group, c_name, c_value FROM counters WHERE group = ? AND c_name IN ?");
    }

    public ResultSetFuture insertData(String bucket, String metricId, long timestamp, Map<Integer, Double> values, int ttl) {
        BoundStatement statement = this.insertData.bind(bucket, metricId, new Date(timestamp), values, ttl);
        return this.session.executeAsync(statement);
    }

    public ResultSetFuture findData(String bucket, String metricId, long startTime, long endTime) {
        BoundStatement statement = this.findData.bind(bucket, metricId, new Date(startTime), new Date(endTime));
        return this.session.executeAsync(statement);
    }

    public ResultSetFuture updateCounter(Counter counter) {
        BoundStatement statement = this.updateCounter.bind(counter.getValue(), counter.getGroup(), counter.getName());
        return this.session.executeAsync(statement);
    }

    public ResultSetFuture updateCounters(Collection<Counter> counters) {
        BatchStatement batchStatement = new BatchStatement(BatchStatement.Type.COUNTER);
        for (Counter counter : counters) {
            batchStatement.add(this.updateCounter.bind(counter.getValue(), counter.getGroup(), counter.getName()));
        }
        return this.session.executeAsync(batchStatement);
    }

    public ResultSetFuture findCounters(String group) {
        BoundStatement statement = this.findCountersByGroup.bind(group);
        return this.session.executeAsync(statement);
    }

    public ResultSetFuture findCounters(String group, List<String> names) {
        BoundStatement statement = this.findCountersByGroupAndName.bind(group, names);
        return this.session.executeAsync(statement);
    }
}

