package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TriggerBuilder extends TriggerFluent<TriggerBuilder> implements VisitableBuilder<Trigger,TriggerBuilder>{
  public TriggerBuilder() {
    this(new Trigger());
  }
  
  public TriggerBuilder(TriggerFluent<?> fluent) {
    this(fluent, new Trigger());
  }
  
  public TriggerBuilder(TriggerFluent<?> fluent,Trigger instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TriggerBuilder(Trigger instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TriggerFluent<?> fluent;
  
  public Trigger build() {
    Trigger buildable = new Trigger(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}