package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import java.util.LinkedHashMap;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SequenceChannelStatusFluent<A extends SequenceChannelStatusFluent<A>> extends BaseFluent<A>{
  public SequenceChannelStatusFluent() {
  }
  
  public SequenceChannelStatusFluent(SequenceChannelStatus instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder channel;
  private ConditionBuilder ready;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SequenceChannelStatus instance) {
    instance = (instance != null ? instance : new SequenceChannelStatus());
    if (instance != null) {
          this.withChannel(instance.getChannel());
          this.withReady(instance.getReady());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildChannel() {
    return this.channel != null ? this.channel.build() : null;
  }
  
  public A withChannel(ObjectReference channel) {
    this._visitables.remove("channel");
    if (channel != null) {
        this.channel = new ObjectReferenceBuilder(channel);
        this._visitables.get("channel").add(this.channel);
    } else {
        this.channel = null;
        this._visitables.get("channel").remove(this.channel);
    }
    return (A) this;
  }
  
  public boolean hasChannel() {
    return this.channel != null;
  }
  
  public ChannelNested<A> withNewChannel() {
    return new ChannelNested(null);
  }
  
  public ChannelNested<A> withNewChannelLike(ObjectReference item) {
    return new ChannelNested(item);
  }
  
  public ChannelNested<A> editChannel() {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(null));
  }
  
  public ChannelNested<A> editOrNewChannel() {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ChannelNested<A> editOrNewChannelLike(ObjectReference item) {
    return withNewChannelLike(java.util.Optional.ofNullable(buildChannel()).orElse(item));
  }
  
  public Condition buildReady() {
    return this.ready != null ? this.ready.build() : null;
  }
  
  public A withReady(Condition ready) {
    this._visitables.remove("ready");
    if (ready != null) {
        this.ready = new ConditionBuilder(ready);
        this._visitables.get("ready").add(this.ready);
    } else {
        this.ready = null;
        this._visitables.get("ready").remove(this.ready);
    }
    return (A) this;
  }
  
  public boolean hasReady() {
    return this.ready != null;
  }
  
  public ReadyNested<A> withNewReady() {
    return new ReadyNested(null);
  }
  
  public ReadyNested<A> withNewReadyLike(Condition item) {
    return new ReadyNested(item);
  }
  
  public ReadyNested<A> editReady() {
    return withNewReadyLike(java.util.Optional.ofNullable(buildReady()).orElse(null));
  }
  
  public ReadyNested<A> editOrNewReady() {
    return withNewReadyLike(java.util.Optional.ofNullable(buildReady()).orElse(new ConditionBuilder().build()));
  }
  
  public ReadyNested<A> editOrNewReadyLike(Condition item) {
    return withNewReadyLike(java.util.Optional.ofNullable(buildReady()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SequenceChannelStatusFluent that = (SequenceChannelStatusFluent) o;
    if (!java.util.Objects.equals(channel, that.channel)) return false;
    if (!java.util.Objects.equals(ready, that.ready)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(channel,  ready,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ChannelNested<N> extends ObjectReferenceFluent<ChannelNested<N>> implements Nested<N>{
    ChannelNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SequenceChannelStatusFluent.this.withChannel(builder.build());
    }
    
    public N endChannel() {
      return and();
    }
    
  
  }
  public class ReadyNested<N> extends ConditionFluent<ReadyNested<N>> implements Nested<N>{
    ReadyNested(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    
    public N and() {
      return (N) SequenceChannelStatusFluent.this.withReady(builder.build());
    }
    
    public N endReady() {
      return and();
    }
    
  
  }

}