/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeflix;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceDiscovery;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiscoveryFeedbackServlet
extends HttpServlet {
    private final InstanceDiscovery instanceDiscovery;

    public DiscoveryFeedbackServlet(InstanceDiscovery instanceDiscovery) {
        this.instanceDiscovery = instanceDiscovery;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        String suffix = DynamicPropertyFactory.getInstance().getStringProperty("turbine.instanceUrlSuffix", "").getValue();
        PrintWriter out = resp.getWriter();
        out.println("<h1>Hystrix Endpoints:</h1>");
        try {
            for (Instance instance : this.instanceDiscovery.getInstanceList()) {
                out.println("<h3>http://" + instance.getHostname() + suffix + " " + instance.getCluster() + ":" + instance.isUp() + "</h3>");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(out);
        }
        out.flush();
    }
}

