/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeflix;

import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.streaming.servlet.TurbineStreamServlet;
import io.fabric8.kubeflix.AggregatorProperties;
import io.fabric8.kubeflix.DiscoveryFeedbackServlet;
import io.fabric8.kubeflix.TurbineLifecycle;
import io.fabric8.kubeflix.turbine.TurbineDiscovery;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Arrays;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AggregatorProperties.class})
public class TurbineConfiguration {
    private static final String DEFAULT_TURBINE_URL_MAPPING = "/turbine.stream";
    private static final String DEFAULT_DISCOVERY_URL_MAPPING = "/discovery";
    @Autowired
    AggregatorProperties aggregatorProperties;

    @Bean
    InstanceDiscovery instanceDiscovery(KubernetesClient client) {
        return new TurbineDiscovery(client, this.aggregatorProperties.getClusters());
    }

    @Bean
    TurbineLifecycle turbineContextListener(InstanceDiscovery instanceDiscovery) {
        return new TurbineLifecycle(instanceDiscovery);
    }

    @Bean
    public ServletRegistrationBean turbineServletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this.turbineStreamServlet(), new String[0]);
        registration.setUrlMappings(Arrays.asList(DEFAULT_TURBINE_URL_MAPPING));
        return registration;
    }

    @Bean
    public ServletRegistrationBean discoveryServletRegistration(InstanceDiscovery instanceDiscovery) {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this.discoveryFeedbackServlet(instanceDiscovery), new String[0]);
        registration.setUrlMappings(Arrays.asList(DEFAULT_DISCOVERY_URL_MAPPING));
        return registration;
    }

    @Bean
    public TurbineStreamServlet turbineStreamServlet() {
        return new TurbineStreamServlet();
    }

    @Bean
    public DiscoveryFeedbackServlet discoveryFeedbackServlet(InstanceDiscovery instanceDiscovery) {
        return new DiscoveryFeedbackServlet(instanceDiscovery);
    }
}

