/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeflix;

import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.init.TurbineInit;
import com.netflix.turbine.plugins.PluginsFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class TurbineLifecycle
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurbineLifecycle.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private final InstanceDiscovery instanceDiscovery;

    public TurbineLifecycle(InstanceDiscovery instanceDiscovery) {
        this.instanceDiscovery = instanceDiscovery;
    }

    public void start() {
        LOGGER.info("Initializing Turbine");
        PluginsFactory.setInstanceDiscovery((InstanceDiscovery)this.instanceDiscovery);
        TurbineInit.init();
        this.running.set(true);
    }

    public void stop() {
        LOGGER.info("Destroying Turbine");
        TurbineInit.stop();
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }
}

