package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LeaderElectionConfigBuilder extends LeaderElectionConfigFluent<LeaderElectionConfigBuilder> implements VisitableBuilder<LeaderElectionConfig,LeaderElectionConfigBuilder>{
  public LeaderElectionConfigBuilder() {
    this.fluent = this;
  }
  
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,LeaderElectionConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LeaderElectionConfigBuilder(LeaderElectionConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LeaderElectionConfigFluent<?> fluent;
  
  public LeaderElectionConfig build() {
    LeaderElectionConfig buildable = new LeaderElectionConfig(fluent.getLock(),fluent.getLeaseDuration(),fluent.getRenewDeadline(),fluent.getRetryPeriod(),fluent.getLeaderCallbacks(),fluent.isReleaseOnCancel(),fluent.getName());
    return buildable;
  }
  

}