/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.BuilderUpdate;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamedNamespacedResource;
import io.fabric8.kubernetes.client.Update;
import io.fabric8.kubernetes.client.internal.BaseResource;
import io.fabric8.kubernetes.client.internal.DefaultResourceList;
import io.fabric8.kubernetes.client.internal.NamespacedResourceList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class NamedResource<T extends HasMetadata, B extends Builder<T>, D extends Doneable<T>>
extends BaseResource<T, B, D>
implements io.fabric8.kubernetes.client.NamedResource<T, B, D>,
NamedNamespacedResource<T, B, D> {
    private URL resourceUrl;

    NamedResource(String name, DefaultResourceList<T, ?, B, D> resourceList) throws MalformedURLException {
        super(resourceList.getHttpClient(), resourceList.getRootUrl(), resourceList.getResourceT(), resourceList.getClazz(), resourceList.getBuilderClazz(), resourceList.getDoneableClazz());
        URL requestUrl = this.getNamespacedUrl();
        this.resourceUrl = new URL(requestUrl, name);
    }

    NamedResource(String name, NamespacedResourceList<T, ?, B, D> resourceList) throws MalformedURLException {
        super(resourceList.getHttpClient(), resourceList.getRootUrl(), resourceList.getResourceT(), resourceList.getClazz(), resourceList.getBuilderClazz(), resourceList.getDoneableClazz());
        this.setNamespace(resourceList.getNamespace());
        URL requestUrl = this.getNamespacedUrl();
        this.resourceUrl = new URL(requestUrl, name);
    }

    @Override
    public T get() throws KubernetesClientException {
        try {
            return this.handleGet(this.resourceUrl);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D edit() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    NamedResource.this.handleUpdate(NamedResource.this.resourceUrl, resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableClazz().getDeclaredConstructor(this.getClazz(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T update(BuilderUpdate<T, B> update) throws KubernetesClientException {
        try {
            T current = this.get();
            T updated = update.apply((Builder)this.getBuilderClazz().getDeclaredConstructor(this.getClazz()).newInstance(current));
            return this.handleUpdate(this.resourceUrl, updated);
        }
        catch (IOException | IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T update(Update<T> update) throws KubernetesClientException {
        try {
            T current = this.get();
            T updated = update.apply(current);
            return this.handleUpdate(this.resourceUrl, updated);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void delete() throws KubernetesClientException {
        try {
            this.handleDelete(this.resourceUrl);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

