/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.Extension;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ReplicationControllerClientResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.EndpointsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.EventOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.NodeOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PersistentVolumeClaimOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PersistentVolumeOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ResourceQuotaOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.SecretOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ServiceAccountOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ServiceOperationsImpl;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClientConfig;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Realm;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.FilterContext;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.FilterException;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.RequestFilter;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ServiceLoader;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class DefaultKubernetesClient
implements KubernetesClient {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private AsyncHttpClient httpClient;
    private URL masterUrl;
    private Config configuration;

    public DefaultKubernetesClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public DefaultKubernetesClient(final Config config) throws KubernetesClientException {
        this.configuration = config;
        if (config.getMasterUrl() == null) {
            throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
        }
        try {
            this.masterUrl = new URL(config.getMasterUrl());
            AsyncHttpClientConfig.Builder clientConfigBuilder = new AsyncHttpClientConfig.Builder();
            clientConfigBuilder.setEnabledProtocols(config.getEnabledProtocols());
            clientConfigBuilder.setFollowRedirect(true);
            clientConfigBuilder.setAcceptAnyCertificate(config.isTrustCerts());
            TrustManager[] trustManagers = null;
            if (config.getCaCertFile() != null || config.getCaCertData() != null) {
                KeyStore trustStore = CertUtils.createTrustStore(config.getCaCertData(), config.getCaCertFile());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            KeyManager[] keyManagers = null;
            if (!(config.getClientCertFile() == null && config.getClientCertData() == null || config.getClientKeyFile() == null && config.getClientKeyData() == null)) {
                KeyStore keyStore = CertUtils.createKeyStore(config.getClientCertData(), config.getClientCertFile(), config.getClientKeyData(), config.getClientKeyFile(), config.getClientKeyAlgo(), config.getClientKeyPassphrase().toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, config.getClientKeyPassphrase().toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            if (keyManagers != null || trustManagers != null) {
                if (trustManagers == null && config.isTrustCerts()) {
                    trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
                    clientConfigBuilder.setHostnameVerifier(null);
                }
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                clientConfigBuilder.setSSLContext(sslContext);
            }
            if (config.getUsername() != null && config.getPassword() != null) {
                Realm realm = new Realm.RealmBuilder().setPrincipal(config.getUsername()).setPassword(config.getPassword()).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
                clientConfigBuilder.setRealm(realm);
            } else if (config.getOauthToken() != null) {
                clientConfigBuilder.addRequestFilter(new RequestFilter(){

                    @Override
                    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                        ctx.getRequest().getHeaders().add("Authorization", "Bearer " + config.getOauthToken());
                        return ctx;
                    }
                });
            }
            NettyAsyncHttpProviderConfig nettyConfig = new NettyAsyncHttpProviderConfig();
            nettyConfig.setWebSocketMaxFrameSize(65536);
            clientConfigBuilder.setAsyncHttpClientProviderConfig(nettyConfig);
            this.httpClient = new AsyncHttpClient(clientConfigBuilder.build());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new KubernetesClientException("Could not create HTTP client", e);
        }
    }

    public DefaultKubernetesClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)((Object)new ConfigBuilder().withMasterUrl(masterUrl))).build());
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = jsonMapper;
            if (intch != 123) {
                mapper = yamlMapper;
            }
            Object object = mapper.readerFor(type).readValue((InputStream)bis);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ClientOperation<KubernetesClient, Endpoints, EndpointsList, DoneableEndpoints, ClientResource<Endpoints, DoneableEndpoints>> endpoints() {
        return new EndpointsOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, Event, EventList, DoneableEvent, ClientResource<Event, DoneableEvent>> events() {
        return new EventOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<KubernetesClient, Namespace, NamespaceList, DoneableNamespace, ClientResource<Namespace, DoneableNamespace>> namespaces() {
        return new NamespaceOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<KubernetesClient, Node, NodeList, DoneableNode, ClientResource<Node, DoneableNode>> nodes() {
        return new NodeOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, ClientResource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return new PersistentVolumeOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, ClientResource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return new PersistentVolumeClaimOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, Pod, PodList, DoneablePod, ClientResource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, ReplicationController, ReplicationControllerList, DoneableReplicationController, ReplicationControllerClientResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, ResourceQuota, ResourceQuotaList, DoneableResourceQuota, ClientResource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return new ResourceQuotaOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, Secret, SecretList, DoneableSecret, ClientResource<Secret, DoneableSecret>> secrets() {
        return new SecretOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, Service, ServiceList, DoneableService, ClientResource<Service, DoneableService>> services() {
        return new ServiceOperationsImpl(this);
    }

    @Override
    public ClientOperation<KubernetesClient, ServiceAccount, ServiceAccountList, DoneableServiceAccount, ClientResource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<KubernetesClient, SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, ClientResource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this);
    }

    @Override
    public RootPaths rootPaths() {
        return (RootPaths)new BaseOperation(this, "", null, null, KubernetesClient.class, RootPaths.class, null, null){}.get();
    }

    @Override
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T extends Extension> T adapt(Class<T> type) {
        for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class)) {
            if (!adapter.getExtensionType().isAssignableFrom(type)) continue;
            return (T)adapter.adapt(this);
        }
        throw new IllegalStateException("Could not find adapter");
    }
}

