/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ReplicationControllerClientResource;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperation;

public class ReplicationControllerOperationsImpl
extends HasMetadataOperation<KubernetesClient, ReplicationController, ReplicationControllerList, DoneableReplicationController, ReplicationControllerClientResource<ReplicationController, DoneableReplicationController>>
implements ReplicationControllerClientResource<ReplicationController, DoneableReplicationController> {
    public ReplicationControllerOperationsImpl(KubernetesClient client) {
        super(client, "replicationcontrollers", null, null);
    }

    public ReplicationControllerOperationsImpl(KubernetesClient client, String namespace, String name) {
        super(client, "replicationcontrollers", namespace, name);
    }

    @Override
    public ReplicationController scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public ReplicationController scale(int count, boolean wait) {
        ReplicationController res = ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.edit(false)).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            res = (ReplicationController)this.get();
            while (res.getStatus().getReplicas() != count) {
                try {
                    Thread.sleep(100L);
                    res = (ReplicationController)this.get();
                }
                catch (InterruptedException e) {
                    throw new KubernetesClientException("Interrupted sleep", e);
                }
            }
        }
        return res;
    }

    public RollingOperation rolling() {
        return new RollingOperation((KubernetesClient)this.getClient(), this.getNamespace(), this.getName());
    }
}

