/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Extension;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class Adapters {
    private static final Map<Class, ExtensionAdapter> EXTENSION_ADAPTER_MAP = new HashMap<Class, ExtensionAdapter>();

    private Adapters() {
    }

    public static <T extends Extension> void register(ExtensionAdapter<T> adapter) {
        EXTENSION_ADAPTER_MAP.put(adapter.getExtensionType(), adapter);
    }

    public static <T extends Extension> void unregister(ExtensionAdapter<T> adapter) {
        EXTENSION_ADAPTER_MAP.remove(adapter.getExtensionType());
    }

    public static <T extends Extension> ExtensionAdapter<T> get(Class<T> type) {
        return EXTENSION_ADAPTER_MAP.get(type);
    }

    static {
        for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class)) {
            Adapters.register(adapter);
        }
    }
}

