/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.EditableContainer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.ImageEditReplaceable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.RollingUpdater;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;

public class ReplicationControllerOperationsImpl<C extends Client>
extends HasMetadataOperation<C, ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>>
implements ClientRollableScallableResource<ReplicationController, DoneableReplicationController>,
ImageEditReplaceable<ReplicationController, ReplicationController, DoneableReplicationController> {
    private final Boolean rolling;

    public ReplicationControllerOperationsImpl(C client) {
        this(client, client.getNamespace(), null, true, null, false);
    }

    public ReplicationControllerOperationsImpl(C client, String namespace, String name, Boolean cascading, ReplicationController item, Boolean rolling) {
        super(client, "replicationcontrollers", namespace, name, cascading, item);
        this.rolling = rolling;
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> load(InputStream is) {
        try {
            ReplicationController item = this.getClient().unmarshal(is, ReplicationController.class);
            return new ReplicationControllerOperationsImpl(this.getClient(), this.getNamespace(), this.getName(), this.isCascading(), item, this.rolling);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<C, ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> inNamespace(String namespace) {
        return new ReplicationControllerOperationsImpl(this.getClient(), namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.rolling);
    }

    @Override
    public ReplicationController scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> withName(String name) {
        return new ReplicationControllerOperationsImpl(this.getClient(), this.getNamespace(), name, this.isCascading(), (ReplicationController)this.getItem(), this.rolling);
    }

    @Override
    public EditReplaceDeletable<ReplicationController, ReplicationController, DoneableReplicationController, Boolean> cascading(boolean enabled) {
        return new ReplicationControllerOperationsImpl(this.getClient(), this.getNamespace(), this.getName(), enabled, (ReplicationController)this.getItem(), this.rolling);
    }

    @Override
    public ReplicationController scale(int count, boolean wait) {
        ReplicationController res = ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            res = (ReplicationController)this.getMandatory();
            while (res.getStatus().getReplicas() != count) {
                try {
                    Thread.sleep(100L);
                    res = (ReplicationController)this.getMandatory();
                }
                catch (InterruptedException e) {
                    throw new KubernetesClientException("Interrupted sleep", e);
                }
            }
        }
        return res;
    }

    public ReplicationControllerOperationsImpl rolling() {
        return new ReplicationControllerOperationsImpl(this.getClient(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), true);
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        EditableContainer updatedContainer = ((ContainerBuilder)new ContainerBuilder((Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicationControllerBuilder newRCBuilder = new ReplicationControllerBuilder(oldRC);
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new RollingUpdater(this.getClient()).rollUpdate(oldRC, (ReplicationController)newRCBuilder.build());
    }

    @Override
    public DoneableReplicationController edit() {
        if (!this.rolling.booleanValue()) {
            return (DoneableReplicationController)super.edit();
        }
        Visitor<ReplicationController> visitor = new Visitor<ReplicationController>(){

            public void visit(ReplicationController rc) {
                try {
                    new RollingUpdater(ReplicationControllerOperationsImpl.this.getClient()).rollUpdate((ReplicationController)ReplicationControllerOperationsImpl.this.getMandatory(), rc);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (DoneableReplicationController)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ReplicationController replace(ReplicationController rc) {
        if (!this.rolling.booleanValue()) {
            return super.replace(rc);
        }
        return new RollingUpdater(this.getClient()).rollUpdate((ReplicationController)this.getMandatory(), rc);
    }
}

