/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;

class RollingUpdater<C extends Client> {
    static final String DEPLOYMENT_KEY = "deployment";
    private C client;

    RollingUpdater(C client) {
        this.client = client;
    }

    ReplicationController rollUpdate(ReplicationController oldRC, ReplicationController newRC) {
        try {
            String namespace = oldRC.getMetadata().getNamespace();
            String oldRCName = oldRC.getMetadata().getName();
            String oldDeploymentHash = this.md5sum((HasMetadata)oldRC);
            PodList oldRCPods = (PodList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)this.pods().inNamespace(namespace)).withLabels(oldRC.getSpec().getSelector())).list();
            for (Pod pod : oldRCPods.getItems()) {
                pod.getMetadata().getLabels().put(DEPLOYMENT_KEY, oldDeploymentHash);
                ((ClientLoggableResource)((ClientNonNamespaceOperation)this.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).replace(pod);
            }
            oldRC.getSpec().getSelector().put(DEPLOYMENT_KEY, oldDeploymentHash);
            oldRC.getSpec().getTemplate().getMetadata().getLabels().put(DEPLOYMENT_KEY, oldDeploymentHash);
            ((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).cascading(false)).replace(oldRC);
            newRC.getMetadata().setResourceVersion(null);
            int requestedNewReplicas = newRC.getSpec().getReplicas();
            newRC.getSpec().setReplicas(Integer.valueOf(0));
            String newDeploymentHash = this.md5sum((HasMetadata)newRC);
            newRC.getSpec().getSelector().put(DEPLOYMENT_KEY, newDeploymentHash);
            newRC.getSpec().getTemplate().getMetadata().getLabels().put(DEPLOYMENT_KEY, newDeploymentHash);
            String newRCName = newRC.getMetadata().getName();
            if (newRCName == null || newRCName.equals(oldRC.getMetadata().getName())) {
                newRC.getMetadata().setName(oldRCName + "-" + newDeploymentHash);
            }
            ReplicationController createdRC = (ReplicationController)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).create(newRC);
            int oldReplicas = oldRC.getSpec().getReplicas();
            while (createdRC.getSpec().getReplicas() < requestedNewReplicas) {
                int newReplicas = createdRC.getSpec().getReplicas() + 1;
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(createdRC.getMetadata().getName())).scale(newReplicas, true);
                createdRC.getSpec().setReplicas(Integer.valueOf(newReplicas));
                if (oldReplicas <= 0) continue;
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).scale(--oldReplicas, true);
            }
            ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).delete();
            if (Objects.equals(oldRCName, newRCName)) {
                createdRC.getMetadata().setResourceVersion(null);
                createdRC.getMetadata().setName(oldRCName);
                createdRC = (ReplicationController)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).create(createdRC);
                ((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName + "-" + newDeploymentHash)).cascading(false)).delete();
                Map createdRCSelector = createdRC.getSpec().getSelector();
                createdRCSelector.remove(DEPLOYMENT_KEY);
                createdRC.getSpec().getTemplate().getMetadata().getLabels().remove(DEPLOYMENT_KEY);
                createdRC = (ReplicationController)((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(createdRC.getMetadata().getName())).cascading(false)).replace(createdRC);
            }
            return createdRC;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new KubernetesClientException("Could not calculate MD5 of RC", e);
        }
    }

    private String md5sum(HasMetadata obj) throws NoSuchAlgorithmException, JsonProcessingException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(SerializationUtils.dumpWithoutRuntimeStateAsYaml(obj).getBytes());
        BigInteger i = new BigInteger(1, digest);
        return String.format("%1$032x", i);
    }

    private ClientOperation<C, ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl<C>(this.client);
    }

    private ClientOperation<C, Pod, PodList, DoneablePod, ClientLoggableResource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl<C>(this.client);
    }
}

