/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.internal.URLUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class BaseOperation<C extends Client, T, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
implements ClientMixedOperation<C, T, L, D, R> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final C client;
    private final String name;
    private final String namespace;
    private final String resourceT;
    private final Boolean cascading;
    private final T item;
    private final Map<String, String> labels = new TreeMap<String, String>();
    private final Map<String, String> labelsNot = new TreeMap<String, String>();
    private final Map<String, String[]> labelsIn = new TreeMap<String, String[]>();
    private final Map<String, String[]> labelsNotIn = new TreeMap<String, String[]>();
    private final Map<String, String> fields = new TreeMap<String, String>();
    private final Class<T> type;
    private final Class<L> listType;
    private final Class<D> doneableType;
    private boolean reaping;

    protected BaseOperation(C client, String resourceT, String namespace, String name, Boolean cascading, T item) {
        this.client = client;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
        this.cascading = cascading;
        this.item = item;
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.listType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        this.doneableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[3];
    }

    protected BaseOperation(C client, String resourceT, String namespace, String name, Boolean cascading, T item, Class<T> type, Class<L> listType, Class<D> doneableType) {
        this.client = client;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
        this.cascading = cascading;
        this.item = item;
        this.type = type;
        this.listType = listType;
        this.doneableType = doneableType;
    }

    @Override
    public T get() {
        if (this.item != null) {
            return this.item;
        }
        try {
            URL requestUrl = this.getNamespacedUrl();
            if (this.name != null) {
                requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.name));
            }
            return this.handleGet(requestUrl);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public RootPaths getRootPaths() {
        try {
            URL requestUrl = this.client.getMasterUrl();
            ListenableFuture f = this.getClient().getHttpClient().prepareGet(requestUrl.toString()).execute();
            Response r = (Response)f.get();
            this.assertResponseCode(r, 200);
            return (RootPaths)mapper.readValue(r.getResponseBodyAsStream(), RootPaths.class);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    T getMandatory() {
        T item = this.get();
        if (item != null) {
            return item;
        }
        throw new KubernetesClientException("Resource not found!", 404, (Status)((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(404))).withMessage("Not found.")).build());
    }

    @Override
    public D edit() throws KubernetesClientException {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public R withName(String name) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(Client.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, name, this.cascading, this.item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<C, T, L, D, R> inNamespace(String namespace) {
        try {
            return (ClientNonNamespaceOperation)this.getClass().getConstructor(Client.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, namespace, this.name, this.cascading, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<C, T, L, D, R> inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public EditReplaceDeletable<T, T, D, Boolean> cascading(boolean enabled) {
        try {
            return (EditReplaceDeletable)this.getClass().getConstructor(Client.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, this.name, enabled, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public R load(InputStream is) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(Client.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, this.name, this.cascading, this.client.unmarshal(is, this.type)));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public T create(T ... resources) throws KubernetesClientException {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    BaseOperation.this.create((T[])new Object[]{resource});
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        this.labelsNot.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withoutLabel(String key, String value) throws KubernetesClientException {
        this.labelsNot.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withFields(Map<String, String> labels) {
        this.fields.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    String getLabelQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.labels != null && !this.labels.isEmpty()) {
            iter = this.labels.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
            iter = this.labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("!=").append(entry.getValue());
            }
        }
        if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
            iter = this.labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" in ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
            iter = this.labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" notin ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        return sb.toString();
    }

    String getFieldQueryParam() {
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && !this.fields.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public L list() throws KubernetesClientException {
        try {
            String fieldQueryString;
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(requestUrl.toString());
            String labelQueryParam = this.getLabelQueryParam();
            if (labelQueryParam.length() > 0) {
                requestBuilder.addQueryParam("labelSelector", labelQueryParam);
            }
            if ((fieldQueryString = this.getFieldQueryParam()).length() > 0) {
                requestBuilder.addQueryParam("fieldSelector", fieldQueryString);
            }
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            this.assertResponseCode(r, 200);
            return (L)((KubernetesResourceList)mapper.readValue(r.getResponseBodyAsStream(), this.listType));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Boolean delete() {
        if (this.name != null && !this.name.isEmpty()) {
            try {
                Reaper reaper;
                if (this.cascading.booleanValue() && !this.isReaping() && (reaper = ReaperFactory.getReaper(this)) != null) {
                    this.setReaping(true);
                    reaper.reap();
                }
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    @Override
    public Boolean delete(T ... items) {
        return this.delete((List)Arrays.asList(items));
    }

    @Override
    public Boolean delete(List<T> items) {
        try {
            for (T item : items) {
                this.handleDelete(item);
            }
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return true;
    }

    void deleteThis() throws KubernetesClientException {
        try {
            if (this.item != null) {
                this.handleDelete(this.item);
            } else {
                this.handleDelete(this.getResourceUrl());
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    void deleteList() throws KubernetesClientException {
        this.delete(this.list().getItems());
    }

    @Override
    public Watch watch(Watcher<T> watcher) throws KubernetesClientException {
        return this.watch(null, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) throws KubernetesClientException {
        try {
            return new WatchConnectionManager(this, resourceVersion, watcher, ((Config)this.client.getConfiguration()).getWatchReconnectInterval(), ((Config)this.client.getConfiguration()).getWatchReconnectLimit());
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T update(T item) {
        return this.replace(item);
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    public boolean isNamespaceRequired() {
        return true;
    }

    protected URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (namespace != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    protected URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    protected URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        if (name == null) {
            return this.getNamespacedUrl(namespace);
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    protected URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    protected String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isNamespaceRequired()) {
                return null;
            }
            throw new KubernetesClientException("Namespace not specified. But operation requires namespace.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        String string = itemName = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected void assertResponseCode(Response r, int expectedStatusCode) {
        int statusCode = r.getStatusCode();
        String customMessage = ((Config)this.client.getConfiguration()).getErrorMessages().get(statusCode);
        if (statusCode == expectedStatusCode) {
            return;
        }
        if (customMessage != null) {
            throw new KubernetesClientException("Error accessing: " + r.getUri().toString() + ",due to:" + customMessage);
        }
        try {
            Status status = (Status)mapper.readValue(r.getResponseBodyAsStream(), Status.class);
            throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
        }
        catch (IOException e) {
            throw new KubernetesClientException(e.getMessage(), statusCode, (Status)((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(statusCode))).withMessage(e.getMessage())).build());
        }
    }

    protected T handleResponse(AsyncHttpClient.BoundRequestBuilder requestBuilder, int successStatusCode) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        ListenableFuture f = requestBuilder.execute();
        Response r = (Response)f.get();
        this.assertResponseCode(r, successStatusCode);
        return (T)mapper.readValue(r.getResponseBodyAsStream(), this.getType());
    }

    protected void handleDelete(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.handleDelete(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource)));
    }

    protected void handleDelete(URL requestUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
        ListenableFuture f = requestBuilder.execute();
        Response r = (Response)f.get();
        this.assertResponseCode(r, 200);
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePost(this.getNamespacedUrl(this.checkNamespace(resource)).toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(resource));
        return this.handleResponse(requestBuilder, 201);
    }

    protected T handleReplace(T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePut(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)).toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(updated));
        return this.handleResponse(requestBuilder, 200);
    }

    protected T handleGet(URL resourceUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(resourceUrl.toString());
        return this.handleResponse(requestBuilder, 200);
    }

    public URL getRootUrl() {
        try {
            return new URL(URLUtils.join(this.client.getMasterUrl().toString(), "api", this.client.getApiVersion()));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public Class<D> getDoneableType() {
        return this.doneableType;
    }

    @Override
    public C getClient() {
        return this.client;
    }

    protected boolean isReaping() {
        return this.reaping;
    }

    protected void setReaping(boolean reaping) {
        this.reaping = reaping;
    }
}

