/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DoneableDeployment;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.ReplicaSetOperationsImpl;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends HasMetadataOperation<Deployment, DeploymentList, DoneableDeployment, ClientScaleableResource<Deployment, DoneableDeployment>>
implements ClientScaleableResource<Deployment, DoneableDeployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Deployment item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, "extensions", apiVersion, "deployments", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentReaper(this);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentIsScaled();
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public DoneableDeployment edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeployment)this.cascading(false).edit();
        }
        return (DoneableDeployment)super.edit();
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    private void waitUntilDeploymentIsScaled() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicDeployment = new AtomicReference();
        Runnable deploymentPoller = new Runnable(){

            @Override
            public void run() {
                int currentReplicas;
                Deployment deployment = (Deployment)DeploymentOperationsImpl.this.getMandatory();
                atomicDeployment.set(deployment);
                int n = currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                if (deployment.getStatus().getObservedGeneration() >= deployment.getMetadata().getGeneration() && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), DeploymentOperationsImpl.this.namespace});
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            executor.shutdown();
            int currentReplicas = ((Deployment)atomicDeployment.get()).getStatus().getReplicas() != null ? ((Deployment)atomicDeployment.get()).getStatus().getReplicas() : 0;
            LOG.error("Only {}/{} pod(s) ready for Deployment: {} in namespace: {} - giving up", new Object[]{currentReplicas, ((Deployment)atomicDeployment.get()).getSpec().getReplicas(), ((Deployment)atomicDeployment.get()).getMetadata().getName(), this.namespace});
        }
    }

    private static class DeploymentReaper
    implements Reaper {
        private DeploymentOperationsImpl oper;

        public DeploymentReaper(DeploymentOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public void reap() {
            Deployment deployment = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DoneableDeployment)this.oper.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(0))).withPaused(Boolean.valueOf(true))).withRevisionHistoryLimit(Integer.valueOf(0))).endSpec()).done();
            this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            this.reapMatchingReplicaSets(deployment.getSpec().getSelector());
        }

        private void waitForObservedGeneration(final long observedGeneration) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    Deployment deployment = (Deployment)DeploymentReaper.this.oper.getMandatory();
                    if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        private void reapMatchingReplicaSets(LabelSelector selector) {
            if (selector == null || selector.getMatchLabels() == null && selector.getMatchExpressions() == null) {
                return;
            }
            ReplicaSetOperationsImpl rsOper = new ReplicaSetOperationsImpl(this.oper.client, this.oper.getConfig(), this.oper.getNamespace());
            rsOper.inNamespace(this.oper.getNamespace());
            if (selector.getMatchLabels() != null) {
                for (Map.Entry entry : selector.getMatchLabels().entrySet()) {
                    rsOper.withLabel((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (selector.getMatchExpressions() != null) {
                for (LabelSelectorRequirement req : selector.getMatchExpressions()) {
                    switch (req.getOperator()) {
                        case "In": {
                            rsOper.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "NotIn": {
                            rsOper.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "DoesNotExist": {
                            rsOper.withoutLabel(req.getKey());
                            break;
                        }
                        case "Exists": {
                            rsOper.withLabel(req.getKey());
                        }
                    }
                }
            }
            rsOper.delete();
        }
    }
}

