/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import java.util.concurrent.CountDownLatch;

public class ReadinessWatcher<T extends HasMetadata>
implements Watcher<T> {
    private final CountDownLatch latch;

    public ReadinessWatcher(CountDownLatch latch) {
        this.latch = latch;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        switch (action) {
            case MODIFIED: {
                if (!Readiness.isReady(resource)) break;
                this.latch.countDown();
                break;
            }
        }
    }

    @Override
    public void onClose(KubernetesClientException e) {
    }
}

