/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.internal.readiness.ReadinessWatcher;
import io.fabric8.kubernetes.client.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetOperationsImpl
extends HasMetadataOperation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, ClientRollableScallableResource<ReplicaSet, DoneableReplicaSet>>
implements ClientRollableScallableResource<ReplicaSet, DoneableReplicaSet>,
TimeoutImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> {
    static final transient Logger LOG = LoggerFactory.getLogger(ReplicaSetOperationsImpl.class);
    private final Boolean rolling;
    private final long rollingTimeout;
    private final TimeUnit rollingTimeUnit;

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicaSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicaSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, "extensions", apiVersion, "replicasets", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit;
        this.reaper = new ReplicaSetReaper(this);
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeout, unit);
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ReplicaSet scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public ClientRollableScallableResource<ReplicaSet, DoneableReplicaSet> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ClientRollableScallableResource<ReplicaSet, DoneableReplicaSet> fromServer() {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public Watchable<Watch, Watcher<ReplicaSet>> withResourceVersion(String resourceVersion) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public EditReplacePatchDeletable<ReplicaSet, ReplicaSet, DoneableReplicaSet, Boolean> cascading(boolean enabled) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicaSet scale(int count, boolean wait) {
        ReplicaSet res = ((DoneableReplicaSet)((ReplicaSetFluent.SpecNested)((DoneableReplicaSet)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilScaled(count);
            res = (ReplicaSet)this.getMandatory();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilScaled(final int count) {
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        final AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        final String name = this.checkName(this.getItem());
        final String namespace = this.checkNamespace(this.getItem());
        Runnable rcPoller = new Runnable(){

            @Override
            public void run() {
                try {
                    long observedGeneration;
                    ReplicaSet rc = (ReplicaSet)ReplicaSetOperationsImpl.this.get();
                    if (rc == null) {
                        if (count == 0) {
                            queue.put(true);
                            return;
                        }
                        queue.put(new IllegalStateException("Can't wait for ReplicaSet: " + name + " in namespace: " + namespace + " to scale. Resource is no longer available."));
                        return;
                    }
                    replicasRef.set(rc.getStatus().getReplicas());
                    long generation = rc.getMetadata().getGeneration() != null ? rc.getMetadata().getGeneration() : 0L;
                    long l = observedGeneration = rc.getStatus() != null && rc.getStatus().getObservedGeneration() != null ? rc.getStatus().getObservedGeneration() : -1L;
                    if (observedGeneration >= generation && Objects.equals(rc.getSpec().getReplicas(), rc.getStatus().getReplicas())) {
                        queue.put(true);
                    }
                    LOG.debug("Only {}/{} replicas scheduled for ReplicaSet: {} in namespace: {} seconds so waiting...", new Object[]{rc.getStatus().getReplicas(), rc.getSpec().getReplicas(), rc.getMetadata().getName(), namespace});
                }
                catch (Throwable t) {
                    LOG.error("Error while waiting for ReplicaSet to be scaled.", t);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(rcPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.rollingTimeout, this.rollingTimeUnit)) {
                LOG.debug("{}/{} pod(s) ready for ReplicaSet: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for ReplicaSet: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, this.rollingTimeUnit.toSeconds(this.rollingTimeout)});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public ReplicaSetOperationsImpl rolling() {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), true, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicaSet updateImage(String image) {
        ReplicaSet oldRC = (ReplicaSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder((Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicaSetBuilder newRCBuilder = new ReplicaSetBuilder(oldRC);
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public DoneableReplicaSet edit() {
        if (!this.rolling.booleanValue()) {
            return (DoneableReplicaSet)super.edit();
        }
        Visitor<ReplicaSet> visitor = new Visitor<ReplicaSet>(){

            public void visit(ReplicaSet rc) {
                try {
                    new ReplicaSetRollingUpdater(ReplicaSetOperationsImpl.this.client, ReplicaSetOperationsImpl.this.config, ReplicaSetOperationsImpl.this.namespace).rollUpdate((HasMetadata)ReplicaSetOperationsImpl.this.getMandatory(), rc);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (DoneableReplicaSet)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ReplicaSet replace(ReplicaSet rc) {
        if (!this.rolling.booleanValue()) {
            return super.replace(rc);
        }
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace, this.rollingTimeUnit.toMillis(this.rollingTimeout), this.getConfig().getLoggingInterval()).rollUpdate((HasMetadata)this.getMandatory(), rc);
    }

    @Override
    public ReplicaSet patch(ReplicaSet rc) {
        if (!this.rolling.booleanValue()) {
            return super.patch(rc);
        }
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace, this.rollingTimeUnit.toMillis(this.rollingTimeout), this.getConfig().getLoggingInterval()).rollUpdate((HasMetadata)this.getMandatory(), rc);
    }

    @Override
    public ReplicaSet waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        ReplicaSet rs = (ReplicaSet)this.get();
        if (rs == null) {
            throw new IllegalArgumentException("ReplicaSet with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        if (Readiness.isReady((HasMetadata)rs)) {
            return rs;
        }
        ReadinessWatcher watcher = new ReadinessWatcher(rs.getKind(), this.getName(), this.getNamespace());
        try (Watch watch = this.watch(watcher);){
            ReplicaSet replicaSet = (ReplicaSet)watcher.await(amount, timeUnit);
            return replicaSet;
        }
    }

    private static class ReplicaSetReaper
    implements Reaper {
        private ReplicaSetOperationsImpl oper;

        public ReplicaSetReaper(ReplicaSetOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            this.oper.scale(0, true);
            return false;
        }
    }
}

