
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DoneablePodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplateList;
import io.fabric8.kubernetes.api.model.DoneablePodTemplate;

import java.util.Map;
import java.util.TreeMap;


public class PodTemplateOperationsImpl extends HasMetadataOperation<PodTemplate, PodTemplateList, DoneablePodTemplate, Resource<PodTemplate, DoneablePodTemplate>> {

  public PodTemplateOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PodTemplateOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PodTemplateOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("podtemplates"));
    this.type = PodTemplate.class;
    this.listType = PodTemplateList.class;
    this.doneableType = DoneablePodTemplate.class;
  }

  public PodTemplateOperationsImpl newInstance(OperationContext context) {
    return new PodTemplateOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
