
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.settings.v1alpha1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.settings.DoneablePodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPresetList;
import io.fabric8.kubernetes.api.model.settings.DoneablePodPreset;

import java.util.Map;
import java.util.TreeMap;


public class PodPresetOperationsImpl extends HasMetadataOperation<PodPreset, PodPresetList, DoneablePodPreset, Resource<PodPreset, DoneablePodPreset>> {

  public PodPresetOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PodPresetOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PodPresetOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("settings.k8s.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("podpresets"));
    this.type = PodPreset.class;
    this.listType = PodPresetList.class;
    this.doneableType = DoneablePodPreset.class;
  }

  public PodPresetOperationsImpl newInstance(OperationContext context) {
    return new PodPresetOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
