/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.storage.v1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1.StorageClassOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StorageClassHandler
implements ResourceHandler<StorageClass, StorageClassBuilder> {
    @Override
    public String getKind() {
        return StorageClass.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "storage.k8s.io/v1";
    }

    @Override
    public StorageClass create(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (StorageClass)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new StorageClass[0]);
    }

    @Override
    public StorageClass replace(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return ((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public StorageClass reload(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (StorageClass)((Gettable)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StorageClassBuilder edit(StorageClass item) {
        return new StorageClassBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, StorageClass item) {
        return new StorageClassOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageClass item, Watcher<StorageClass> watcher) {
        return ((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageClass item, String resourceVersion, Watcher<StorageClass> watcher) {
        return ((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageClass item, ListOptions options, Watcher<StorageClass> watcher) {
        return ((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public StorageClass waitUntilReady(OkHttpClient client, Config config, String namespace, StorageClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageClass)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StorageClass waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageClass item, Predicate<StorageClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageClass)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

