/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Readiable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.client.utils.DeleteAndCreateHelper;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<HasMetadata, HasMetadata>,
Readiable {
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final Object item;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean dryRun) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is), -1L, null, cascading, watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier, dryRun);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean dryRun) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.checkForHandlerOf(item);
        this.cascading = cascading;
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.dryRun = dryRun;
        this.visitors.add((Visitor)new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        String namespaceToUse = meta.getMetadata().getNamespace();
        if (Boolean.TRUE.equals(this.deletingExisting)) {
            return DeleteAndCreateHelper.deleteAndCreateItem(this.client, this.config, meta, h, namespaceToUse, this.propagationPolicy, this.gracePeriodSeconds, this.dryRun);
        }
        return CreateOrReplaceHelper.createOrReplaceItem(this.client, this.config, meta, h, namespaceToUse, this.dryRun);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Boolean delete() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, this.gracePeriodSeconds, meta, this.dryRun);
    }

    @Override
    public HasMetadata get() {
        if (this.fromServer.booleanValue()) {
            HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
            ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
            HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            if (reloaded != null) {
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    edited = (HasMetadata)((VisitableBuilder)h.edit(edited).accept(new Visitor[]{v})).build();
                }
                return edited;
            }
            return null;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        for (Visitor v : visitors) {
            newVisitors.add(v);
        }
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<HasMetadata> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<HasMetadata> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Deletable cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        long watchRetryInitialBackoffMillis = backoffUnit.toMillis(initialBackoff);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, watchRetryInitialBackoffMillis, backoffMultiplier, this.dryRun);
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, resourceVersion, watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, options, watcher);
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    @Override
    public final Boolean isReady() {
        return this.getReadiness().isReady(this.get());
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        try {
            return h.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public VisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, isDryRun);
    }

    @Override
    public HasMetadata waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        try {
            return h.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors) {
        ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        Object builder = h.edit(item);
        for (Visitor v : visitors) {
            builder.accept(new Visitor[]{v});
        }
        return (HasMetadata)builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> HasMetadata asHasMetadata(T item) {
        if (item instanceof HasMetadata) {
            return (HasMetadata)item;
        }
        if (!(item instanceof String)) throw new IllegalArgumentException("Item needs to be an instance of HasMetadata or String.");
        try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
            HasMetadata hasMetadata = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is));
            return hasMetadata;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    static <T> ResourceHandler<? extends KubernetesResource, ?> checkForHandlerOf(T item) {
        if (item instanceof HasMetadata) {
            return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf((HasMetadata)item);
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
    }

    static <T extends HasMetadata> ResourceHandler<HasMetadata, ?> handlerOf(T item) {
        return Handlers.get(item.getKind(), item.getApiVersion());
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

