/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.SharedInformerOperationsImpl;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.OkHttpClient;

public class SharedInformerFactory {
    private final List<Map.Entry<OperationContext, SharedIndexInformer>> informers = new ArrayList<Map.Entry<OperationContext, SharedIndexInformer>>();
    private final ExecutorService informerExecutor;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();
    private boolean allowShutdown = true;
    private SharedInformerFactoryBaseOperation baseOperation;

    public SharedInformerFactory(OkHttpClient okHttpClient, Config configuration) {
        this(Utils.getCommonExecutorSerive(), okHttpClient, configuration);
        this.allowShutdown = false;
    }

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        this.baseOperation = new SharedInformerFactoryBaseOperation(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.initOperationContext(configuration);
        this.informerExecutor = threadPool;
        this.baseOperation.setNamespace(null);
    }

    @Deprecated
    public SharedInformerFactory inNamespace(String namespace) {
        this.baseOperation.setNamespace(namespace);
        return this;
    }

    @Deprecated
    public SharedInformerFactory withName(String name) {
        this.baseOperation.setName(name);
        return this;
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), null, resyncPeriodInMillis, Utils.isResourceNamespaced(apiTypeClass));
    }

    @Deprecated
    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis, Utils.isResourceNamespaced(apiTypeClass));
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        KubernetesDeserializer.registerCustomKind((String)String.format("%s/%s", Objects.requireNonNull(customResourceContext.getGroup()), Objects.requireNonNull(customResourceContext.getVersion())), (String)Optional.ofNullable(customResourceContext.getKind()).orElse(apiTypeClass.getSimpleName()), apiTypeClass);
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.baseOperation.getContext().withApiGroupName(customResourceContext.getGroup()).withApiGroupVersion(customResourceContext.getVersion()).withPlural(customResourceContext.getPlural()).withIsNamespaceConfiguredFromGlobalConfig(this.baseOperation.getContext().isNamespaceFromGlobalConfig()), resyncPeriodInMillis, Utils.isResourceNamespaced(apiTypeClass));
    }

    public synchronized SharedIndexInformer<GenericKubernetesResource> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext genericResourceContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(GenericKubernetesResource.class, GenericKubernetesResourceList.class, new OperationContext().withApiGroupName(genericResourceContext.getGroup()).withApiGroupVersion(genericResourceContext.getVersion()).withPlural(genericResourceContext.getPlural()).withNamespace(this.baseOperation.getNamespace()).withIsNamespaceConfiguredFromGlobalConfig(this.baseOperation.getContext().isNamespaceFromGlobalConfig()), resyncPeriodInMillis, genericResourceContext.isNamespaceScoped());
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis, Utils.isResourceNamespaced(apiTypeClass));
    }

    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerForCustomResource(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, null, resyncPeriodInMillis, Utils.isResourceNamespaced(apiTypeClass));
    }

    private synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis, boolean isResourceNamespaced) {
        ListerWatcher<T, L> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass, isResourceNamespaced);
        OperationContext context = this.baseOperation.getContext().withApiGroupName(HasMetadata.getGroup(apiTypeClass)).withApiGroupVersion(HasMetadata.getVersion(apiTypeClass)).withPlural(HasMetadata.getPlural(apiTypeClass)).withIsNamespaceConfiguredFromGlobalConfig(this.baseOperation.getContext().isNamespaceFromGlobalConfig());
        if (this.baseOperation.getNamespace() != null) {
            context = context.withNamespace(this.baseOperation.getNamespace()).withIsNamespaceConfiguredFromGlobalConfig(false);
        }
        if (this.baseOperation.getName() != null) {
            context = context.withFields(Collections.singletonMap("metadata.name", this.baseOperation.getName()));
        }
        if (operationContext != null) {
            context = context.withOperationContext(operationContext);
            if (operationContext.getNamespace() != null) {
                context = context.withIsNamespaceConfiguredFromGlobalConfig(false);
            }
        }
        DefaultSharedIndexInformer<T, L> informer = new DefaultSharedIndexInformer<T, L>(apiTypeClass, listerWatcher, resyncPeriodInMillis, context, this.informerExecutor);
        this.informers.add(new AbstractMap.SimpleEntry<OperationContext, DefaultSharedIndexInformer<T, L>>(context, informer));
        return informer;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> ListerWatcher<T, L> listerWatcherFor(final Class<T> apiTypeClass, final Class<L> apiListTypeClass, final boolean isResourceNamespaced) {
        return new ListerWatcher<T, L>(){

            @Override
            public L list(ListOptions params, String namespace, OperationContext context) {
                BaseOperation listBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass, isResourceNamespaced);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass, isResourceNamespaced);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        for (Map.Entry<OperationContext, SharedIndexInformer> entry : this.informers) {
            if (!entry.getValue().getApiTypeClass().equals(apiTypeClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Deprecated
    public List<Map.Entry<OperationContext, SharedIndexInformer>> getExistingSharedIndexInformers() {
        return Collections.unmodifiableList(this.informers);
    }

    public synchronized Future<Void> startAllRegisteredInformers() {
        ArrayList<CompletableFuture<Boolean>> startInformerTasks = new ArrayList<CompletableFuture<Boolean>>();
        if (!this.informers.isEmpty() && !this.informerExecutor.isShutdown()) {
            for (Map.Entry<OperationContext, SharedIndexInformer> entry : this.informers) {
                startInformerTasks.add(this.startInformerAsync(entry.getValue()));
            }
        }
        return CompletableFuture.allOf(startInformerTasks.toArray(new CompletableFuture[0]));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        this.informers.forEach(e -> ((SharedIndexInformer)e.getValue()).stop());
        if (shutDownThreadPool && this.allowShutdown) {
            this.informerExecutor.shutdown();
        }
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }

    private synchronized CompletableFuture<Boolean> startInformerAsync(SharedIndexInformer informer) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.informerExecutor.submit(() -> {
            try {
                informer.run();
                completableFuture.complete(true);
            }
            catch (RuntimeException e) {
                this.eventListeners.forEach(listener -> listener.onException(informer, e));
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> BaseOperation<T, L, ?> getConfiguredBaseOperation(String namespace, OperationContext context, Class<T> apiTypeClass, Class<L> apiListTypeClass, boolean isNamespacedScoped) {
        SharedInformerOperationsImpl sharedInformerOperations = context.isNamespaceFromGlobalConfig() ? new SharedInformerOperationsImpl(context.withConfig(((ConfigBuilder)new ConfigBuilder(this.baseOperation.getConfig()).withNamespace(null)).build()).withNamespace(null), isNamespacedScoped) : new SharedInformerOperationsImpl(context.withNamespace(namespace), isNamespacedScoped);
        sharedInformerOperations.setType(apiTypeClass);
        sharedInformerOperations.setListType(apiListTypeClass);
        return sharedInformerOperations;
    }

    private void initOperationContext(Config configuration) {
        if (configuration.getNamespace() != null) {
            this.baseOperation.setContext(this.baseOperation.getContext().withIsNamespaceConfiguredFromGlobalConfig(true));
        }
    }

    private <T extends HasMetadata> void registerKindToKubernetesDeserializer(Class<T> apiTypeClass) {
        if (CustomResource.class.isAssignableFrom(apiTypeClass)) {
            KubernetesDeserializer.registerCustomKind((String)HasMetadata.getApiVersion(apiTypeClass), (String)apiTypeClass.getSimpleName(), apiTypeClass);
        }
    }

    private class SharedInformerFactoryBaseOperation
    extends BaseOperation {
        private SharedInformerFactoryBaseOperation(OperationContext ctx) {
            super(ctx);
        }

        private OperationContext getContext() {
            return this.context;
        }

        private void setContext(OperationContext context) {
            this.context = context;
        }

        private void setName(String name) {
            this.name = name;
        }
    }
}

