/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.NodeAffinity;
import io.fabric8.kubernetes.api.model.NodeAffinityBuilder;
import io.fabric8.kubernetes.api.model.NodeAffinityFluent;
import io.fabric8.kubernetes.api.model.PodAffinity;
import io.fabric8.kubernetes.api.model.PodAffinityBuilder;
import io.fabric8.kubernetes.api.model.PodAffinityFluent;
import io.fabric8.kubernetes.api.model.PodAntiAffinity;
import io.fabric8.kubernetes.api.model.PodAntiAffinityBuilder;
import io.fabric8.kubernetes.api.model.PodAntiAffinityFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AffinityFluent<A extends AffinityFluent<A>>
extends BaseFluent<A> {
    private NodeAffinityBuilder nodeAffinity;
    private PodAffinityBuilder podAffinity;
    private PodAntiAffinityBuilder podAntiAffinity;
    private Map<String, Object> additionalProperties;

    public AffinityFluent() {
    }

    public AffinityFluent(Affinity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Affinity instance) {
        Affinity affinity = instance = instance != null ? instance : new Affinity();
        if (instance != null) {
            this.withNodeAffinity(instance.getNodeAffinity());
            this.withPodAffinity(instance.getPodAffinity());
            this.withPodAntiAffinity(instance.getPodAntiAffinity());
            this.withNodeAffinity(instance.getNodeAffinity());
            this.withPodAffinity(instance.getPodAffinity());
            this.withPodAntiAffinity(instance.getPodAntiAffinity());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NodeAffinity buildNodeAffinity() {
        return this.nodeAffinity != null ? this.nodeAffinity.build() : null;
    }

    public A withNodeAffinity(NodeAffinity nodeAffinity) {
        this._visitables.remove((Object)this.nodeAffinity);
        if (nodeAffinity != null) {
            this.nodeAffinity = new NodeAffinityBuilder(nodeAffinity);
            this._visitables.get((Object)"nodeAffinity").add(this.nodeAffinity);
        } else {
            this.nodeAffinity = null;
            this._visitables.get((Object)"nodeAffinity").remove((Object)this.nodeAffinity);
        }
        return (A)((Object)this);
    }

    public boolean hasNodeAffinity() {
        return this.nodeAffinity != null;
    }

    public NodeAffinityNested<A> withNewNodeAffinity() {
        return new NodeAffinityNested(null);
    }

    public NodeAffinityNested<A> withNewNodeAffinityLike(NodeAffinity item) {
        return new NodeAffinityNested(item);
    }

    public NodeAffinityNested<A> editNodeAffinity() {
        return this.withNewNodeAffinityLike(Optional.ofNullable(this.buildNodeAffinity()).orElse(null));
    }

    public NodeAffinityNested<A> editOrNewNodeAffinity() {
        return this.withNewNodeAffinityLike(Optional.ofNullable(this.buildNodeAffinity()).orElse(new NodeAffinityBuilder().build()));
    }

    public NodeAffinityNested<A> editOrNewNodeAffinityLike(NodeAffinity item) {
        return this.withNewNodeAffinityLike(Optional.ofNullable(this.buildNodeAffinity()).orElse(item));
    }

    public PodAffinity buildPodAffinity() {
        return this.podAffinity != null ? this.podAffinity.build() : null;
    }

    public A withPodAffinity(PodAffinity podAffinity) {
        this._visitables.remove((Object)this.podAffinity);
        if (podAffinity != null) {
            this.podAffinity = new PodAffinityBuilder(podAffinity);
            this._visitables.get((Object)"podAffinity").add(this.podAffinity);
        } else {
            this.podAffinity = null;
            this._visitables.get((Object)"podAffinity").remove((Object)this.podAffinity);
        }
        return (A)((Object)this);
    }

    public boolean hasPodAffinity() {
        return this.podAffinity != null;
    }

    public PodAffinityNested<A> withNewPodAffinity() {
        return new PodAffinityNested(null);
    }

    public PodAffinityNested<A> withNewPodAffinityLike(PodAffinity item) {
        return new PodAffinityNested(item);
    }

    public PodAffinityNested<A> editPodAffinity() {
        return this.withNewPodAffinityLike(Optional.ofNullable(this.buildPodAffinity()).orElse(null));
    }

    public PodAffinityNested<A> editOrNewPodAffinity() {
        return this.withNewPodAffinityLike(Optional.ofNullable(this.buildPodAffinity()).orElse(new PodAffinityBuilder().build()));
    }

    public PodAffinityNested<A> editOrNewPodAffinityLike(PodAffinity item) {
        return this.withNewPodAffinityLike(Optional.ofNullable(this.buildPodAffinity()).orElse(item));
    }

    public PodAntiAffinity buildPodAntiAffinity() {
        return this.podAntiAffinity != null ? this.podAntiAffinity.build() : null;
    }

    public A withPodAntiAffinity(PodAntiAffinity podAntiAffinity) {
        this._visitables.remove((Object)this.podAntiAffinity);
        if (podAntiAffinity != null) {
            this.podAntiAffinity = new PodAntiAffinityBuilder(podAntiAffinity);
            this._visitables.get((Object)"podAntiAffinity").add(this.podAntiAffinity);
        } else {
            this.podAntiAffinity = null;
            this._visitables.get((Object)"podAntiAffinity").remove((Object)this.podAntiAffinity);
        }
        return (A)((Object)this);
    }

    public boolean hasPodAntiAffinity() {
        return this.podAntiAffinity != null;
    }

    public PodAntiAffinityNested<A> withNewPodAntiAffinity() {
        return new PodAntiAffinityNested(null);
    }

    public PodAntiAffinityNested<A> withNewPodAntiAffinityLike(PodAntiAffinity item) {
        return new PodAntiAffinityNested(item);
    }

    public PodAntiAffinityNested<A> editPodAntiAffinity() {
        return this.withNewPodAntiAffinityLike(Optional.ofNullable(this.buildPodAntiAffinity()).orElse(null));
    }

    public PodAntiAffinityNested<A> editOrNewPodAntiAffinity() {
        return this.withNewPodAntiAffinityLike(Optional.ofNullable(this.buildPodAntiAffinity()).orElse(new PodAntiAffinityBuilder().build()));
    }

    public PodAntiAffinityNested<A> editOrNewPodAntiAffinityLike(PodAntiAffinity item) {
        return this.withNewPodAntiAffinityLike(Optional.ofNullable(this.buildPodAntiAffinity()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityFluent that = (AffinityFluent)((Object)o);
        if (!Objects.equals((Object)this.nodeAffinity, (Object)that.nodeAffinity)) {
            return false;
        }
        if (!Objects.equals((Object)this.podAffinity, (Object)that.podAffinity)) {
            return false;
        }
        if (!Objects.equals((Object)this.podAntiAffinity, (Object)that.podAntiAffinity)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeAffinity, this.podAffinity, this.podAntiAffinity, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeAffinity != null) {
            sb.append("nodeAffinity:");
            sb.append((Object)((Object)this.nodeAffinity) + ",");
        }
        if (this.podAffinity != null) {
            sb.append("podAffinity:");
            sb.append((Object)((Object)this.podAffinity) + ",");
        }
        if (this.podAntiAffinity != null) {
            sb.append("podAntiAffinity:");
            sb.append((Object)((Object)this.podAntiAffinity) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodAntiAffinityNested<N>
    extends PodAntiAffinityFluent<PodAntiAffinityNested<N>>
    implements Nested<N> {
        PodAntiAffinityBuilder builder;

        PodAntiAffinityNested(PodAntiAffinity item) {
            this.builder = new PodAntiAffinityBuilder(this, item);
        }

        public N and() {
            return (N)AffinityFluent.this.withPodAntiAffinity(this.builder.build());
        }

        public N endPodAntiAffinity() {
            return this.and();
        }
    }

    public class PodAffinityNested<N>
    extends PodAffinityFluent<PodAffinityNested<N>>
    implements Nested<N> {
        PodAffinityBuilder builder;

        PodAffinityNested(PodAffinity item) {
            this.builder = new PodAffinityBuilder(this, item);
        }

        public N and() {
            return (N)AffinityFluent.this.withPodAffinity(this.builder.build());
        }

        public N endPodAffinity() {
            return this.and();
        }
    }

    public class NodeAffinityNested<N>
    extends NodeAffinityFluent<NodeAffinityNested<N>>
    implements Nested<N> {
        NodeAffinityBuilder builder;

        NodeAffinityNested(NodeAffinity item) {
            this.builder = new NodeAffinityBuilder(this, item);
        }

        public N and() {
            return (N)AffinityFluent.this.withNodeAffinity(this.builder.build());
        }

        public N endNodeAffinity() {
            return this.and();
        }
    }
}

