package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventSeriesBuilder extends EventSeriesFluentImpl<EventSeriesBuilder> implements VisitableBuilder<EventSeries,EventSeriesBuilder>{
  public EventSeriesBuilder() {
    this(false);
  }
  public EventSeriesBuilder(Boolean validationEnabled) {
    this(new EventSeries(), validationEnabled);
  }
  public EventSeriesBuilder(EventSeriesFluent<?> fluent) {
    this(fluent, false);
  }
  public EventSeriesBuilder(EventSeriesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventSeries(), validationEnabled);
  }
  public EventSeriesBuilder(EventSeriesFluent<?> fluent,EventSeries instance) {
    this(fluent, instance, false);
  }
  public EventSeriesBuilder(EventSeriesFluent<?> fluent,EventSeries instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCount(instance.getCount());
      fluent.withLastObservedTime(instance.getLastObservedTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventSeriesBuilder(EventSeries instance) {
    this(instance,false);
  }
  public EventSeriesBuilder(EventSeries instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCount(instance.getCount());
      this.withLastObservedTime(instance.getLastObservedTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventSeriesFluent<?> fluent;
  Boolean validationEnabled;
  public EventSeries build() {
    EventSeries buildable = new EventSeries(fluent.getCount(),fluent.getLastObservedTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}