/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.events.v1beta1.Event;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeries;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeriesBuilder;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeriesFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EventFluent<A extends EventFluent<A>>
extends BaseFluent<A> {
    private String action;
    private String apiVersion;
    private Integer deprecatedCount;
    private String deprecatedFirstTimestamp;
    private String deprecatedLastTimestamp;
    private EventSource deprecatedSource;
    private MicroTime eventTime;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String note;
    private String reason;
    private ObjectReferenceBuilder regarding;
    private ObjectReferenceBuilder related;
    private String reportingController;
    private String reportingInstance;
    private EventSeriesBuilder series;
    private String type;
    private Map<String, Object> additionalProperties;

    public EventFluent() {
    }

    public EventFluent(Event instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Event instance) {
        Event event = instance = instance != null ? instance : new Event();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withDeprecatedCount(instance.getDeprecatedCount());
            this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
            this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
            this.withDeprecatedSource(instance.getDeprecatedSource());
            this.withEventTime(instance.getEventTime());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNote(instance.getNote());
            this.withReason(instance.getReason());
            this.withRegarding(instance.getRegarding());
            this.withRelated(instance.getRelated());
            this.withReportingController(instance.getReportingController());
            this.withReportingInstance(instance.getReportingInstance());
            this.withSeries(instance.getSeries());
            this.withType(instance.getType());
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withDeprecatedCount(instance.getDeprecatedCount());
            this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
            this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
            this.withDeprecatedSource(instance.getDeprecatedSource());
            this.withEventTime(instance.getEventTime());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNote(instance.getNote());
            this.withReason(instance.getReason());
            this.withRegarding(instance.getRegarding());
            this.withRelated(instance.getRelated());
            this.withReportingController(instance.getReportingController());
            this.withReportingInstance(instance.getReportingInstance());
            this.withSeries(instance.getSeries());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)((Object)this);
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    public A withDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return (A)((Object)this);
    }

    public boolean hasDeprecatedCount() {
        return this.deprecatedCount != null;
    }

    public String getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    public A withDeprecatedFirstTimestamp(String deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return (A)((Object)this);
    }

    public boolean hasDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp != null;
    }

    public String getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    public A withDeprecatedLastTimestamp(String deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return (A)((Object)this);
    }

    public boolean hasDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp != null;
    }

    public EventSource getDeprecatedSource() {
        return this.deprecatedSource;
    }

    public A withDeprecatedSource(EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
        return (A)((Object)this);
    }

    public boolean hasDeprecatedSource() {
        return this.deprecatedSource != null;
    }

    public A withNewDeprecatedSource(String component, String host) {
        return this.withDeprecatedSource(new EventSource(component, host));
    }

    public MicroTime getEventTime() {
        return this.eventTime;
    }

    public A withEventTime(MicroTime eventTime) {
        this.eventTime = eventTime;
        return (A)((Object)this);
    }

    public boolean hasEventTime() {
        return this.eventTime != null;
    }

    public A withNewEventTime(String time) {
        return this.withEventTime(new MicroTime(time));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getNote() {
        return this.note;
    }

    public A withNote(String note) {
        this.note = note;
        return (A)((Object)this);
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public ObjectReference buildRegarding() {
        return this.regarding != null ? this.regarding.build() : null;
    }

    public A withRegarding(ObjectReference regarding) {
        this._visitables.remove((Object)this.regarding);
        if (regarding != null) {
            this.regarding = new ObjectReferenceBuilder(regarding);
            this._visitables.get((Object)"regarding").add(this.regarding);
        } else {
            this.regarding = null;
            this._visitables.get((Object)"regarding").remove(this.regarding);
        }
        return (A)((Object)this);
    }

    public boolean hasRegarding() {
        return this.regarding != null;
    }

    public RegardingNested<A> withNewRegarding() {
        return new RegardingNested(null);
    }

    public RegardingNested<A> withNewRegardingLike(ObjectReference item) {
        return new RegardingNested(item);
    }

    public RegardingNested<A> editRegarding() {
        return this.withNewRegardingLike(Optional.ofNullable(this.buildRegarding()).orElse(null));
    }

    public RegardingNested<A> editOrNewRegarding() {
        return this.withNewRegardingLike(Optional.ofNullable(this.buildRegarding()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RegardingNested<A> editOrNewRegardingLike(ObjectReference item) {
        return this.withNewRegardingLike(Optional.ofNullable(this.buildRegarding()).orElse(item));
    }

    public ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    public A withRelated(ObjectReference related) {
        this._visitables.remove((Object)this.related);
        if (related != null) {
            this.related = new ObjectReferenceBuilder(related);
            this._visitables.get((Object)"related").add(this.related);
        } else {
            this.related = null;
            this._visitables.get((Object)"related").remove(this.related);
        }
        return (A)((Object)this);
    }

    public boolean hasRelated() {
        return this.related != null;
    }

    public RelatedNested<A> withNewRelated() {
        return new RelatedNested(null);
    }

    public RelatedNested<A> withNewRelatedLike(ObjectReference item) {
        return new RelatedNested(item);
    }

    public RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(null));
    }

    public RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(item));
    }

    public String getReportingController() {
        return this.reportingController;
    }

    public A withReportingController(String reportingController) {
        this.reportingController = reportingController;
        return (A)((Object)this);
    }

    public boolean hasReportingController() {
        return this.reportingController != null;
    }

    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)((Object)this);
    }

    public boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    public EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    public A withSeries(EventSeries series) {
        this._visitables.remove((Object)this.series);
        if (series != null) {
            this.series = new EventSeriesBuilder(series);
            this._visitables.get((Object)"series").add(this.series);
        } else {
            this.series = null;
            this._visitables.get((Object)"series").remove((Object)this.series);
        }
        return (A)((Object)this);
    }

    public boolean hasSeries() {
        return this.series != null;
    }

    public SeriesNested<A> withNewSeries() {
        return new SeriesNested(null);
    }

    public SeriesNested<A> withNewSeriesLike(EventSeries item) {
        return new SeriesNested(item);
    }

    public SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(null));
    }

    public SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(new EventSeriesBuilder().build()));
    }

    public SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventFluent that = (EventFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedCount, that.deprecatedCount)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedFirstTimestamp, that.deprecatedFirstTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedLastTimestamp, that.deprecatedLastTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedSource, that.deprecatedSource)) {
            return false;
        }
        if (!Objects.equals(this.eventTime, that.eventTime)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.note, that.note)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.regarding, that.regarding)) {
            return false;
        }
        if (!Objects.equals(this.related, that.related)) {
            return false;
        }
        if (!Objects.equals(this.reportingController, that.reportingController)) {
            return false;
        }
        if (!Objects.equals(this.reportingInstance, that.reportingInstance)) {
            return false;
        }
        if (!Objects.equals((Object)this.series, (Object)that.series)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.apiVersion, this.deprecatedCount, this.deprecatedFirstTimestamp, this.deprecatedLastTimestamp, this.deprecatedSource, this.eventTime, this.kind, this.metadata, this.note, this.reason, this.regarding, this.related, this.reportingController, this.reportingInstance, this.series, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.deprecatedCount != null) {
            sb.append("deprecatedCount:");
            sb.append(this.deprecatedCount + ",");
        }
        if (this.deprecatedFirstTimestamp != null) {
            sb.append("deprecatedFirstTimestamp:");
            sb.append(this.deprecatedFirstTimestamp + ",");
        }
        if (this.deprecatedLastTimestamp != null) {
            sb.append("deprecatedLastTimestamp:");
            sb.append(this.deprecatedLastTimestamp + ",");
        }
        if (this.deprecatedSource != null) {
            sb.append("deprecatedSource:");
            sb.append(this.deprecatedSource + ",");
        }
        if (this.eventTime != null) {
            sb.append("eventTime:");
            sb.append(this.eventTime + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.note != null) {
            sb.append("note:");
            sb.append(this.note + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.regarding != null) {
            sb.append("regarding:");
            sb.append(this.regarding + ",");
        }
        if (this.related != null) {
            sb.append("related:");
            sb.append(this.related + ",");
        }
        if (this.reportingController != null) {
            sb.append("reportingController:");
            sb.append(this.reportingController + ",");
        }
        if (this.reportingInstance != null) {
            sb.append("reportingInstance:");
            sb.append(this.reportingInstance + ",");
        }
        if (this.series != null) {
            sb.append("series:");
            sb.append((Object)((Object)this.series) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SeriesNested<N>
    extends EventSeriesFluent<SeriesNested<N>>
    implements Nested<N> {
        EventSeriesBuilder builder;

        SeriesNested(EventSeries item) {
            this.builder = new EventSeriesBuilder(this, item);
        }

        public N and() {
            return (N)EventFluent.this.withSeries(this.builder.build());
        }

        public N endSeries() {
            return this.and();
        }
    }

    public class RelatedNested<N>
    extends ObjectReferenceFluent<RelatedNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RelatedNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)EventFluent.this.withRelated(this.builder.build());
        }

        public N endRelated() {
            return this.and();
        }
    }

    public class RegardingNested<N>
    extends ObjectReferenceFluent<RegardingNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RegardingNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)EventFluent.this.withRegarding(this.builder.build());
        }

        public N endRegarding() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)EventFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

