/*
 * Decompiled with CFR 0.152.
 */
package io.fares.junit.mongodb;

import com.mongodb.MongoClient;
import io.fares.junit.mongodb.MongoTestBase;
import io.fares.junit.mongodb.WithoutMongo;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MongoRule
implements TestRule {
    public static final String UNIT_TEST_DB = "unitdb";
    private final MongoTestBase testCase;

    public MongoRule() {
        this(new MongoTestBase(){});
    }

    public MongoRule(String host, int port) {
        this(new MongoTestBase(){}.withMongoHost(host).withMongoPort(port));
    }

    public MongoRule(MongoTestBase testCase) {
        this.testCase = testCase;
    }

    public Statement apply(final Statement base, Description description) {
        if (description.getAnnotation(WithoutMongo.class) != null) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                MongoRule.this.testCase.startMongo();
                MongoRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    MongoRule.this.after();
                    MongoRule.this.testCase.shutdownMongo();
                }
            }
        };
    }

    protected void before() throws Throwable {
    }

    protected void after() {
    }

    public MongoClient getMongoClient() {
        return this.testCase.getMongoClient();
    }

    public String getMongoHost() {
        return this.testCase.getMongoHost();
    }

    protected void setMogoHost(String host) {
        this.testCase.setMogoHost(host);
    }

    public int getMongoPort() {
        return this.testCase.getMongoPort();
    }

    protected void setMogoPort(int port) {
        this.testCase.setMogoPort(port);
    }

    public String getVersion() {
        return this.testCase.getVersion();
    }

    protected void setVersion(String version) {
        this.testCase.setVersion(version);
    }

    protected void setVersion(String version, boolean syncDelay) {
        this.testCase.setVersion(version, syncDelay);
    }

    public MongoRule host(String host) {
        this.setMogoHost(host);
        return this;
    }

    public MongoRule port(int port) {
        this.setMogoPort(port);
        return this;
    }

    public MongoRule version(String version) {
        this.setVersion(version);
        return this;
    }

    public MongoRule version(String version, boolean syncDelay) {
        this.setVersion(version, syncDelay);
        return this;
    }
}

