/*
 * Decompiled with CFR 0.152.
 */
package io.fares.junit.mongodb;

import com.mongodb.MongoClient;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoTestBase {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private IFeatureAwareVersion version = Version.Main.PRODUCTION;
    private String mongodHost = "localhost";
    private int mongodPort = 27099;
    protected MongodExecutable mongoExec = null;
    protected MongodProcess mongod = null;
    protected MongoClient mongoClient = null;

    protected MongoClient startMongo() throws UnknownHostException, IOException {
        IRuntimeConfig runConfig = new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, this.log).build();
        MongodStarter runtime = MongodStarter.getInstance((IRuntimeConfig)runConfig);
        IMongodConfig mongodConfig = new MongodConfigBuilder().version(this.version).net(new Net(this.mongodPort, Network.localhostIsIPv6())).build();
        this.mongoExec = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)mongodConfig);
        this.mongod = (MongodProcess)this.mongoExec.start();
        int waitCount = 1;
        while (!this.mongod.isProcessRunning() || waitCount > 10) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Force wait start {}", (Object)waitCount);
                }
                ++waitCount;
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mongoClient = new MongoClient(this.getMongoHost(), this.getMongoPort());
        return this.mongoClient;
    }

    protected void shutdownMongo() {
        if (this.mongod != null) {
            this.mongod.stop();
            int waitCount = 1;
            while (this.mongod.isProcessRunning() || waitCount > 10) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Force wait shutdown {}", (Object)waitCount);
                    }
                    ++waitCount;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.mongoExec != null) {
            this.mongoExec.stop();
        }
    }

    public String getMongoHost() {
        return this.mongodHost;
    }

    protected void setMogoHost(String host) {
        this.mongodHost = host;
    }

    public int getMongoPort() {
        return this.mongodPort;
    }

    protected void setMogoPort(int port) {
        this.mongodPort = port;
    }

    protected MongoClient getMongoClient() {
        return this.mongoClient;
    }

    protected MongoTestBase withMongoHost(String host) {
        this.setMogoHost(host);
        return this;
    }

    protected MongoTestBase withMongoPort(int port) {
        this.setMogoPort(port);
        return this;
    }

    public String getVersion() {
        return this.version == null ? Version.Main.PRODUCTION.asInDownloadPath() : this.version.asInDownloadPath();
    }

    public void setVersion(String version) {
        this.setVersion(version, true);
    }

    public void setVersion(String version, boolean syncDelay) {
        this.version = syncDelay ? Versions.withFeatures((IVersion)new GenericVersion(version), (Feature[])new Feature[]{Feature.SYNC_DELAY}) : Versions.withFeatures((IVersion)new GenericVersion(version), (Feature[])new Feature[0]);
    }

    public MongoTestBase withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public MongoTestBase withVersion(String version, boolean syncDelay) {
        this.setVersion(version, syncDelay);
        return this;
    }
}

