/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.stats.ErrorRecord;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.GroupRecord;
import io.gatling.charts.stats.LogFileParser;
import io.gatling.charts.stats.LogFileParser$;
import io.gatling.charts.stats.RequestRecord;
import io.gatling.charts.stats.ResultsHolder;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.stats.StatsHelper$;
import io.gatling.charts.stats.UserRecord;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.writer.RecordHeader;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005q4Aa\u0005\u000b\u0007;!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\rCQa\u0012\u0001\u0005\u0002!Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019i\u0006\u0001)A\u0005/\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00021\u0001A\u0003%!\u0005C\u0003b\u0001\u0011%!\rC\u0003g\u0001\u0011%q\rC\u0003l\u0001\u0011%A\u000eC\u0003q\u0001\u0011%\u0011\u000fC\u0003v\u0001\u0011%a\u000fC\u0003{\u0001\u0011\u00053P\u0001\tTK\u000e|g\u000e\u001a)bgN\u0004\u0016M]:fe*\u0011QCF\u0001\u0006gR\fGo\u001d\u0006\u0003/a\taa\u00195beR\u001c(BA\r\u001b\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aG\u0001\u0003S>\u001c\u0001aE\u0002\u0001=\u0015\u00022a\b\u0011#\u001b\u0005!\u0012BA\u0011\u0015\u00055aun\u001a$jY\u0016\u0004\u0016M]:feB\u0011qdI\u0005\u0003IQ\u0011QBU3tk2$8\u000fS8mI\u0016\u0014\bC\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ3&\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0013aA2p[&\u0011af\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u000f1|wMR5mKB\u0011\u0011'N\u0007\u0002e)\u00111d\r\u0006\u0002i\u0005!!.\u0019<b\u0013\t1$G\u0001\u0003GS2,\u0017a\u0002:v]&sgm\u001c\t\u0003?eJ!A\u000f\u000b\u0003\u000fI+h.\u00138g_\u0006!1\u000f^3q!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019!u.\u001e2mK\u0006QAn\\<fe\n{WO\u001c3\u0011\u0005u\"\u0015BA#?\u0005\rIe\u000e^\u0001\fQ&<\u0007.\u001a:C_VtG-\u0001\u0004=S:LGO\u0010\u000b\u0007\u0013*[E*\u0014(\u0011\u0005}\u0001\u0001\"B\u0018\u0007\u0001\u0004\u0001\u0004\"B\u001c\u0007\u0001\u0004A\u0004\"B\u001e\u0007\u0001\u0004a\u0004\"\u0002\"\u0007\u0001\u0004\u0019\u0005\"\u0002$\u0007\u0001\u0004\u0019\u0015a\u00022vG.,Go]\u000b\u0002#B\u0019QHU\"\n\u0005Ms$!B!se\u0006L\u0018\u0001\u00032vG.,Go\u001d\u0011\u0002\u001d\t,8m[3u\rVt7\r^5p]V\tq\u000b\u0005\u0003>1j\u001b\u0015BA-?\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002>7&\u0011AL\u0010\u0002\u0005\u0019>tw-A\bck\u000e\\W\r\u001e$v]\u000e$\u0018n\u001c8!\u00035\u0011Xm];miNDu\u000e\u001c3feV\t!%\u0001\bsKN,H\u000e^:I_2$WM\u001d\u0011\u0002\u001bM\\\u0017\u000e\u001d*v]J+7m\u001c:e)\u0005\u0019\u0007CA\u001fe\u0013\t)gH\u0001\u0003V]&$\u0018a\u00049beN,Wk]3s%\u0016\u001cwN\u001d3\u0015\u0003!\u0004\"aH5\n\u0005)$\"AC+tKJ\u0014VmY8sI\u0006\u0011\u0002/\u0019:tKJ+\u0017/^3tiJ+7m\u001c:e)\u0005i\u0007CA\u0010o\u0013\tyGCA\u0007SKF,Xm\u001d;SK\u000e|'\u000fZ\u0001\u0011a\u0006\u00148/Z$s_V\u0004(+Z2pe\u0012$\u0012A\u001d\t\u0003?ML!\u0001\u001e\u000b\u0003\u0017\u001d\u0013x.\u001e9SK\u000e|'\u000fZ\u0001\u0011a\u0006\u00148/Z#se>\u0014(+Z2pe\u0012$\u0012a\u001e\t\u0003?aL!!\u001f\u000b\u0003\u0017\u0015\u0013(o\u001c:SK\u000e|'\u000fZ\u0001\u0006a\u0006\u00148/\u001a\u000b\u0002E\u0001")
public final class SecondPassParser
extends LogFileParser<ResultsHolder>
implements StrictLogging {
    private final RunInfo runInfo;
    private final int[] buckets;
    private final Function1<Object, Object> bucketFunction;
    private final ResultsHolder resultsHolder;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int[] buckets() {
        return this.buckets;
    }

    private Function1<Object, Object> bucketFunction() {
        return this.bucketFunction;
    }

    private ResultsHolder resultsHolder() {
        return this.resultsHolder;
    }

    private void skipRunRecord() {
        this.skipByte();
        this.skipString();
        this.skipString();
        this.skipLong();
        this.skipString();
        int scenariosSize = this.readInt();
        int limit$macro$4 = scenariosSize;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            this.skipString();
        }
        int assertionsSize = this.readInt();
        int limit$macro$9 = assertionsSize;
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            this.skip(this.readInt());
        }
    }

    private UserRecord parseUserRecord() {
        return new UserRecord(this.runInfo.scenarios()[this.readInt()], (MessageEvent)(this.readBoolean() ? MessageEvent.Start$.MODULE$ : MessageEvent.End$.MODULE$), (long)this.readInt() + this.runInfo.runStart());
    }

    private RequestRecord parseRequestRecord() {
        int groupsSize = this.readInt();
        Option group = Option$.MODULE$.when(groupsSize > 0, (Function0 & Serializable)() -> new Group((List<String>)((List)package$.MODULE$.List().fill(groupsSize, (Function0 & Serializable)() -> this.readCachedSanitizedString()))));
        String name = this.readCachedSanitizedString();
        long startTimestamp = (long)this.readInt() + this.runInfo.runStart();
        long endTimestamp = (long)this.readInt() + this.runInfo.runStart();
        OK$ status = this.readBoolean() ? OK$.MODULE$ : KO$.MODULE$;
        Option errorMessage = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(this.readCachedSanitizedString()));
        if (endTimestamp != Long.MIN_VALUE) {
            return new RequestRecord((Option<Group>)group, name, (Status)status, startTimestamp, this.bucketFunction().apply$mcIJ$sp(startTimestamp), this.bucketFunction().apply$mcIJ$sp(endTimestamp), (int)(endTimestamp - startTimestamp), (Option<String>)errorMessage, false);
        }
        return new RequestRecord((Option<Group>)group, name, (Status)status, startTimestamp, this.bucketFunction().apply$mcIJ$sp(startTimestamp), this.bucketFunction().apply$mcIJ$sp(endTimestamp), 0, (Option<String>)errorMessage, true);
    }

    private GroupRecord parseGroupRecord() {
        int groupsSize = this.readInt();
        Group group = new Group((List<String>)((List)package$.MODULE$.List().fill(groupsSize, (Function0 & Serializable)() -> this.readCachedSanitizedString())));
        long startTimestamp = (long)this.readInt() + this.runInfo.runStart();
        long endTimestamp = (long)this.readInt() + this.runInfo.runStart();
        int cumulatedResponseTime = this.readInt();
        OK$ status = this.readBoolean() ? OK$.MODULE$ : KO$.MODULE$;
        return new GroupRecord(group, (int)(endTimestamp - startTimestamp), cumulatedResponseTime, (Status)status, startTimestamp, this.bucketFunction().apply$mcIJ$sp(startTimestamp));
    }

    private ErrorRecord parseErrorRecord() {
        String message = this.readCachedSanitizedString();
        long timestamp = (long)this.readInt() + this.runInfo.runStart();
        return new ErrorRecord(message, timestamp);
    }

    @Override
    public ResultsHolder parse() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.skipRunRecord();
        int count = 1;
        boolean bl = true;
        while (bl) {
            BoxedUnit boxedUnit3;
            if (++count % LogFileParser$.MODULE$.LogStep() == 0) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("First pass, read {} records", (Object)BoxesRunTime.boxToInteger((int)count));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            byte headerValue = (byte)this.read();
            try {
                byte by = headerValue;
                if (RecordHeader.User$.MODULE$.value() == by) {
                    this.resultsHolder().addUserRecord(this.parseUserRecord());
                    continue;
                }
                if (RecordHeader.Request$.MODULE$.value() == by) {
                    this.resultsHolder().addRequestRecord(this.parseRequestRecord());
                    continue;
                }
                if (RecordHeader.Group$.MODULE$.value() == by) {
                    this.resultsHolder().addGroupRecord(this.parseGroupRecord());
                    continue;
                }
                if (RecordHeader.Error$.MODULE$.value() == by) {
                    this.resultsHolder().addErrorRecord(this.parseErrorRecord());
                    continue;
                }
                if (-1 == by) {
                    bl = false;
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported header " + headerValue + " for record " + count);
            }
            catch (EOFException e) {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Log file is truncated after record " + count + ", can only generate partial results.", (Throwable)e);
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                bl = false;
            }
        }
        this.resultsHolder().endDandlingStartedUser();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass: read {} records", (Object)BoxesRunTime.boxToInteger((int)count));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.resultsHolder();
    }

    public SecondPassParser(File logFile, RunInfo runInfo, double step, int lowerBound, int higherBound) {
        this.runInfo = runInfo;
        super(logFile);
        StrictLogging.$init$((StrictLogging)this);
        this.buckets = StatsHelper$.MODULE$.buckets(0L, runInfo.injectEnd() - runInfo.injectStart(), step);
        this.bucketFunction = StatsHelper$.MODULE$.timeToBucketNumber(runInfo.injectStart(), step, this.buckets().length);
        this.resultsHolder = new ResultsHolder(runInfo.injectStart(), runInfo.injectEnd(), this.buckets(), lowerBound, higherBound);
        Statics.releaseFence();
    }
}

