/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Block;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u000e\u001d\u0003\u00039\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001d\t\b\u00011A\u0005\nIDqA\u001e\u0001A\u0002\u0013%q\u000f\u0003\u0004~\u0001\u0001\u0006Ka\u001d\u0005\b}\u0002\u0001\r\u0011\"\u0003s\u0011!y\b\u00011A\u0005\n\u0005\u0005\u0001bBA\u0003\u0001\u0001\u0006Ka\u001d\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0005\u0003\u0013A\u0011\"!\u0005\u0001\u0001\u0004%I!a\u0005\t\u0011\u0005]\u0001\u0001)Q\u0005\u0003\u0017Aq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002\u001e\u0001!\t\"a\u0007\t\u000f\u0005}\u0001\u0001\"\u0005\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0002bBA\u0015\u0001\u0011E\u00111\u0006\u0005\u0007\u0003\u007f\u0001A\u0011\u0003:\t\u000f\u0005\u0005\u0003A\"\u0001\u0002D!9\u0011\u0011\n\u0001\u0007\u0002\u0005-\u0003bBA/\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003?\u0002A\u0011AA\u0005\u0005!9vN]6m_\u0006$'BA\u000f\u001f\u0003\u0019IgN[3di*\u0011q\u0004I\u0001\u000bG>tGO]8mY\u0016\u0014(BA\u0011#\u0003\u0011\u0019wN]3\u000b\u0005\r\"\u0013aB4bi2Lgn\u001a\u0006\u0002K\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001a5\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001b\u0002\u0007\r|W.\u0003\u00028a\ti1\u000b\u001e:jGRdunZ4j]\u001e\f\u0001b]2f]\u0006\u0014\u0018n\u001c\t\u0003uqj\u0011a\u000f\u0006\u0003q\u0001J!!P\u001e\u0003\u0011M\u001bWM\\1sS>\f\u0011\"^:fe&#w)\u001a8\u0011\u0005\u0001KU\"A!\u000b\u0005\t\u001b\u0015AB1u_6L7M\u0003\u0002E\u000b\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0019;\u0015\u0001B;uS2T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u0003\nQ\u0011\t^8nS\u000eduN\\4\u0002\u0013M$\u0018M\u001d;US6,\u0007CA\u0015N\u0013\tq%F\u0001\u0003M_:<\u0017AB:zgR,W\u000e\u0005\u0002R-6\t!K\u0003\u0002T)\u0006)\u0011m\u0019;pe*\tQ+\u0001\u0003bW.\f\u0017BA,S\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0017M$\u0018\r^:F]\u001eLg.\u001a\t\u00035vk\u0011a\u0017\u0006\u00039\u0002\nQa\u001d;biNL!AX.\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0006G2|7m\u001b\t\u0003C\u0016l\u0011A\u0019\u0006\u0003\r\u000eT!\u0001\u001a\u0012\u0002\u000f\r|W.\\8og&\u0011aM\u0019\u0002\u0006\u00072|7m[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f%\\G.\u001c8paB\u0011!\u000eA\u0007\u00029!)\u0001h\u0002a\u0001s!)ah\u0002a\u0001\u007f!)1j\u0002a\u0001\u0019\")qj\u0002a\u0001!\")\u0001l\u0002a\u00013\")ql\u0002a\u0001A\u0006I1o\u00195fIVdW\rZ\u000b\u0002gB\u0011\u0011\u0006^\u0005\u0003k*\u00121!\u00138u\u00035\u00198\r[3ek2,Gm\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003SeL!A\u001f\u0016\u0003\tUs\u0017\u000e\u001e\u0005\by&\t\t\u00111\u0001t\u0003\rAH%M\u0001\u000bg\u000eDW\rZ;mK\u0012\u0004\u0013aB:u_B\u0004X\rZ\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000fF\u0002y\u0003\u0007Aq\u0001 \u0007\u0002\u0002\u0003\u00071/\u0001\u0005ti>\u0004\b/\u001a3!\u00031\tG\u000e\\*dQ\u0016$W\u000f\\3e+\t\tY\u0001E\u0002*\u0003\u001bI1!a\u0004+\u0005\u001d\u0011un\u001c7fC:\f\u0001#\u00197m'\u000eDW\rZ;mK\u0012|F%Z9\u0015\u0007a\f)\u0002\u0003\u0005}\u001f\u0005\u0005\t\u0019AA\u0006\u00035\tG\u000e\\*dQ\u0016$W\u000f\\3eA\u00059\u0012N\\2sK6,g\u000e^*dQ\u0016$W\u000f\\3e+N,'o\u001d\u000b\u0002q\u0006y1/\u001a;BY2\u001c6\r[3ek2,G-A\u000bj]\u000e\u0014X-\\3oiN#x\u000e\u001d9fIV\u001bXM]:\u0002\u0013M$\u0018M\u001d;Vg\u0016\u0014Hc\u0001=\u0002&!1\u0011q\u0005\u000bA\u00021\u000ba!^:fe&#\u0017AC5oU\u0016\u001cG/V:feR\u0019\u00010!\f\t\u000f\u0005=R\u00031\u0001\u00022\u0005)A-\u001a7bsB!\u00111GA\u001e\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\u0011S\u0013\u0002BA\u001f\u0003k\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\nhKR\u001cuN\\2veJ,g\u000e^+tKJ\u001c\u0018aC5oU\u0016\u001cGOQ1uG\"$2\u0001_A#\u0011\u001d\t9e\u0006a\u0001\u0003c\t1BY1uG\"<\u0016N\u001c3po\u00069QM\u001c3Vg\u0016\u0014Hc\u0001=\u0002N!9\u0011q\n\rA\u0002\u0005E\u0013aC;tKJlUm]:bO\u0016\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/Z\u0016AB<sSR,'/\u0003\u0003\u0002\\\u0005U#aC+tKJlUm]:bO\u0016\f1#[:BY2,6/\u001a:t'\u000eDW\rZ;mK\u0012\f\u0011#[:BY2,6/\u001a:t'R|\u0007\u000f]3e\u0001")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private int scheduled;
    private int stopped;
    private boolean allScheduled;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(int x$1) {
        this.scheduled = x$1;
    }

    private int stopped() {
        return this.stopped;
    }

    private void stopped_$eq(int x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1);
    }

    public void setAllScheduled() {
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1);
    }

    private void startUser(long userId) {
        BoxedUnit boxedUnit;
        String x$1 = this.scenario.name();
        long x$2 = userId;
        long x$3 = this.clock.nowMillis();
        Function1<Session, BoxedUnit> x$4 = this.scenario.onExit();
        Map<String, Object> x$5 = Session$.MODULE$.apply$default$4();
        long x$6 = Session$.MODULE$.apply$default$5();
        Status x$7 = Session$.MODULE$.apply$default$6();
        List<Block> x$8 = Session$.MODULE$.apply$default$7();
        Session rawSession = new Session(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$4);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        this.scenario.entry().$bang(session);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", new Object[]{BoxesRunTime.boxToLong((long)session.userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUser(new UserMessage(session, Start$.MODULE$, session.startDate()));
    }

    public void injectUser(FiniteDuration delay) {
        this.incrementScheduledUsers();
        long userId = this.userIdGen.incrementAndGet();
        if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
            this.startUser(userId);
        } else {
            this.system.scheduler().scheduleOnce(delay, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startUser(userId), (ExecutionContext)this.system.dispatcher());
        }
    }

    public int getConcurrentUsers() {
        return this.scheduled() - this.stopped();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser(UserMessage var1);

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public Workload(Scenario scenario, AtomicLong userIdGen, long startTime, ActorSystem system, StatsEngine statsEngine, Clock clock) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0;
        this.stopped = 0;
        this.allScheduled = false;
    }
}

