/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.ErrorStats;
import io.gatling.core.stats.writer.ConsoleStatsFormat$;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ConsoleSummary$ {
    public static final ConsoleSummary$ MODULE$ = new ConsoleSummary$();

    public String formatSubTitle(String title) {
        return StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString("---- " + title + " "), ConsoleStatsFormat$.MODULE$.ConsoleWidth(), "-");
    }

    public ConsoleSummary apply(long runDuration, Map<String, UserCounters> usersCounters, RequestCounters globalRequestCounters, Map<String, RequestCounters> requestsCounters, Map<String, Object> errorsCounters, GatlingConfiguration configuration, TemporalAccessor time, DateTimeFormatter dateTimeFormatter) {
        String formattedTime = dateTimeFormatter.format(time);
        StringBuilder sb = new StringBuilder().append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |" + ConsoleStatsFormat$.MODULE$.NewBlock() + "\n                 |" + formattedTime + " " + StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(Long.toString(runDuration) + "s elapsed"), ConsoleStatsFormat$.MODULE$.ConsoleWidth() - formattedTime.length() - 9) + "\n                 |" + ConsoleStatsFormat$.MODULE$.formatSubTitleWithStatuses("Requests") + "\n                 |")));
        ConsoleSummary$.writeRequestsCounter$1(sb, "Global", globalRequestCounters).append(StringHelper$.MODULE$.Eol());
        ConsoleSummary$.writeDetailedRequestsCounter$1(sb, configuration, requestsCounters).append(StringHelper$.MODULE$.Eol());
        this.writeErrors$1(sb, errorsCounters).append(StringHelper$.MODULE$.Eol());
        usersCounters.foreachEntry((Function2 & Serializable)(scenarioName, usersStats) -> this.writeUsersCounters$1(sb, (String)scenarioName, (UserCounters)usersStats).append(StringHelper$.MODULE$.Eol()));
        sb.append(ConsoleStatsFormat$.MODULE$.NewBlock()).append(StringHelper$.MODULE$.Eol());
        String text = sb.toString();
        long totalWaiting = BoxesRunTime.unboxToLong((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(usersCounters.values()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.waitingCount()), (Numeric)Numeric.LongIsIntegral$.MODULE$));
        long totalRunning = BoxesRunTime.unboxToLong((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(usersCounters.values()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.activeCount()), (Numeric)Numeric.LongIsIntegral$.MODULE$));
        boolean complete = totalWaiting == 0L && totalRunning == 0L;
        return new ConsoleSummary(text, complete);
    }

    private final StringBuilder writeUsersCounters$1(StringBuilder sb, String scenarioName, UserCounters userCounters) {
        Some some;
        long tot;
        Option<Object> option = userCounters.totalUserCount();
        if (option instanceof Some && (tot = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= userCounters.doneCount() + userCounters.activeCount()) {
            int width = ConsoleStatsFormat$.MODULE$.ConsoleWidth() - 8;
            double donePercent = (double)100 * (double)userCounters.doneCount() / (double)tot;
            int done = (int)package$.MODULE$.floor((double)width * (double)userCounters.doneCount() / (double)tot);
            int active = (int)package$.MODULE$.ceil((double)width * (double)userCounters.activeCount() / (double)tot);
            int waiting = width - done - active;
            return sb.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.formatSubTitle(scenarioName) + "\n               |[" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("#"), done) + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("|"), active) + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), waiting) + "]" + StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(NumberHelper.RichDouble$.MODULE$.toPrintableString$extension(NumberHelper$.MODULE$.RichDouble(donePercent)) + "%"), 6) + "\n               |          waiting: " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToLong((long)userCounters.waitingCount()), Numeric.LongIsIntegral$.MODULE$) + " / active: " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToLong((long)userCounters.activeCount()), Numeric.LongIsIntegral$.MODULE$) + "  / done: " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToLong((long)userCounters.doneCount()), Numeric.LongIsIntegral$.MODULE$))));
        }
        return sb.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.formatSubTitle(scenarioName) + "\n                       |          active: " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToLong((long)userCounters.activeCount()), Numeric.LongIsIntegral$.MODULE$) + "  / done: " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToLong((long)userCounters.doneCount()), Numeric.LongIsIntegral$.MODULE$))));
    }

    private static final StringBuilder writeRequestsCounter$1(StringBuilder sb, String actionName, RequestCounters requestCounters) {
        int maxActionNameLength = ConsoleStatsFormat$.MODULE$.ConsoleWidth() - ConsoleStatsFormat$.MODULE$.HeaderLength() - 3 * (ConsoleStatsFormat$.MODULE$.NumberLength() + 3);
        return sb.append(ConsoleStatsFormat$.MODULE$.Header() + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(actionName), maxActionNameLength)), maxActionNameLength) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToInteger((int)(requestCounters.successfulCount() + requestCounters.failedCount())), Numeric.IntIsIntegral$.MODULE$) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToInteger((int)requestCounters.successfulCount()), Numeric.IntIsIntegral$.MODULE$) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(BoxesRunTime.boxToInteger((int)requestCounters.failedCount()), Numeric.IntIsIntegral$.MODULE$));
    }

    private static final StringBuilder writeDetailedRequestsCounter$1(StringBuilder sb, GatlingConfiguration configuration$1, Map requestsCounters$1) {
        block1: {
            if (configuration$1.data().console().light()) break block1;
            requestsCounters$1.foreachEntry((Function2 & Serializable)(actionName, requestCounters) -> ConsoleSummary$.writeRequestsCounter$1(sb, actionName, requestCounters).append(StringHelper$.MODULE$.Eol()));
            if (requestsCounters$1.nonEmpty()) {
                sb.setLength(sb.length() - StringHelper$.MODULE$.Eol().length());
            }
        }
        return sb;
    }

    public static final /* synthetic */ int $anonfun$apply$2(Tuple2 x$1) {
        return -x$1._2$mcI$sp();
    }

    private final StringBuilder writeErrors$1(StringBuilder sb, Map errorsCounters$1) {
        block0: {
            if (!errorsCounters$1.nonEmpty()) break block0;
            int errorsTotal = BoxesRunTime.unboxToInt((Object)errorsCounters$1.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            sb.append(this.formatSubTitle("Errors")).append(StringHelper$.MODULE$.Eol());
            ((IterableOnceOps)errorsCounters$1.toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ConsoleSummary$.$anonfun$apply$2(x$1)), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String message = (String)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    return ConsoleStatsFormat$.MODULE$.writeError(sb, new ErrorStats(message, count, errorsTotal)).append(StringHelper$.MODULE$.Eol());
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return sb;
    }

    private ConsoleSummary$() {
    }
}

