/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.accessor;

import com.jn.langx.Accessor;
import com.jn.langx.accessor.AccessorFactory;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Accessors {
    private static final Map<Class, AccessorFactory> accessorFactoryRegistry = new LinkedHashMap<Class, AccessorFactory>();

    private Accessors() {
    }

    public static void register(final AccessorFactory accessorFactory) {
        List<Class> classes = accessorFactory.applyTo();
        if (Objs.isNotEmpty(classes)) {
            Collects.forEach(classes, new Consumer<Class>(){

                @Override
                public void accept(Class aClass) {
                    accessorFactoryRegistry.put(aClass, accessorFactory);
                }
            });
        }
    }

    public static <T> AccessorFactory<T> findFactory(final @NonNull Class klass) {
        Set<Class> classes;
        Class matched;
        Preconditions.checkNotNull(klass);
        AccessorFactory factory = accessorFactoryRegistry.get(klass);
        if (factory == null && (matched = Collects.findFirst(classes = accessorFactoryRegistry.keySet(), new Predicate<Class>(){

            @Override
            public boolean test(Class expectedClass) {
                return ((AccessorFactory)accessorFactoryRegistry.get(expectedClass)).appliable(expectedClass, klass);
            }
        })) != null) {
            factory = accessorFactoryRegistry.get(matched);
        }
        return factory;
    }

    public static <T> Accessor<String, T> of(@NonNull Class klass) {
        AccessorFactory<T> factory = Accessors.findFactory(klass);
        if (factory == null) {
            return null;
        }
        return factory.get(klass);
    }

    public static <T> Accessor<String, T> of(@NonNull T object) {
        Preconditions.checkNotNull(object);
        Accessor<String, Class<?>> accessor = Accessors.of(object.getClass());
        if (accessor != null) {
            accessor.setTarget((Class<?>)object);
        }
        return accessor;
    }

    static {
        Collects.forEach(CommonServiceProvider.loadService(AccessorFactory.class), new Consumer<AccessorFactory>(){

            @Override
            public void accept(AccessorFactory accessorFactory) {
                Accessors.register(accessorFactory);
            }
        });
    }
}

