/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.accessor;

import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import java.util.Collection;
import java.util.List;

public class StringKeyCollectionAccessor
extends BasedStringAccessor<String, Collection> {
    @Override
    public void setTarget(Collection target) {
        super.setTarget(Pipeline.of(target).asList());
    }

    @Override
    public void setTarget(Object ... elements) {
        this.setTarget(Collects.asList(elements));
    }

    @Override
    public void remove(String key) {
        ((Collection)this.getTarget()).remove(this.toIndex(key));
    }

    private int toIndex(String key) {
        return Numbers.createInteger(key);
    }

    @Override
    public Object get(String key) {
        return ((List)this.getTarget()).get(this.toIndex(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object element = ((List)this.getTarget()).get(this.toIndex(key));
        if (Objs.isNotNull(element)) {
            return element.toString();
        }
        return defaultValue;
    }

    @Override
    public void set(String key, Object value) {
        ((List)this.getTarget()).set(this.toIndex(key), value);
    }
}

