/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.beans;

import com.jn.langx.beans.BeanInfoFactory;
import com.jn.langx.beans.BeansException;
import com.jn.langx.beans.GenericTypeAwarePropertyDescriptor;
import com.jn.langx.beans.TypeDescriptor;
import com.jn.langx.util.Strings;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

final class CachedIntrospectionResults {
    public static final String IGNORE_BEANINFO_PROPERTY_NAME = "langx.beans.beaninfo.ignore";
    private static final boolean shouldIntrospectorIgnoreBeaninfoClasses = SystemPropertys.getAccessor().getBoolean("langx.beans.beaninfo.ignore", true);
    private static List<BeanInfoFactory> beanInfoFactories = Collects.asList(ServiceLoader.load(BeanInfoFactory.class, CachedIntrospectionResults.class.getClassLoader()));
    private static final Logger logger = Loggers.getLogger(CachedIntrospectionResults.class);
    static final Set<ClassLoader> acceptedClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap(16));
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> strongClassCache = new ConcurrentHashMap(64);
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> softClassCache = new ConcurrentReferenceHashMap(64);
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;
    private final ConcurrentMap<PropertyDescriptor, TypeDescriptor> typeDescriptorCache;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    public static void clearClassLoader(ClassLoader classLoader) {
        Class beanClass;
        Iterator<ClassLoader> it = acceptedClassLoaders.iterator();
        while (it.hasNext()) {
            ClassLoader registeredLoader = it.next();
            if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
            it.remove();
        }
        it = strongClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
        it = softClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
    }

    public static CachedIntrospectionResults forClass(Class<?> beanClass) throws BeansException {
        ConcurrentMap<Class<?>, CachedIntrospectionResults> classCacheToUse;
        CachedIntrospectionResults results = (CachedIntrospectionResults)strongClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = (CachedIntrospectionResults)softClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = new CachedIntrospectionResults(beanClass);
        if (Reflects.isCacheSafe(beanClass, CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader())) {
            classCacheToUse = strongClassCache;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Not strongly caching class [{}] because it is not cache-safe", (Object)beanClass.getName());
            }
            classCacheToUse = softClassCache;
        }
        CachedIntrospectionResults existing = classCacheToUse.putIfAbsent(beanClass, results);
        return existing != null ? existing : results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        for (ClassLoader acceptedLoader : acceptedClassLoaders) {
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, acceptedLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == parent) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class<?> beanClass) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            PropertyDescriptor[] beanInfoFactory;
            if (logger.isDebugEnabled()) {
                logger.debug("Getting BeanInfo for class [{}]", (Object)Reflects.getFQNClassName(beanClass));
            }
            BeanInfo beanInfo = null;
            Iterator<BeanInfoFactory> iterator = beanInfoFactories.iterator();
            while (iterator.hasNext() && (beanInfo = (beanInfoFactory = iterator.next()).getBeanInfo(beanClass)) == null) {
            }
            if (beanInfo == null) {
                beanInfo = shouldIntrospectorIgnoreBeaninfoClasses ? Introspector.getBeanInfo(beanClass, 3) : Introspector.getBeanInfo(beanClass);
            }
            this.beanInfo = beanInfo;
            if (logger.isDebugEnabled()) {
                logger.debug("Caching PropertyDescriptors for class [{}]", (Object)Reflects.getFQNClassName(beanClass));
            }
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
                if (Class.class == beanClass && ("classLoader".equals(pd.getName()) || "protectionDomain".equals(pd.getName()))) continue;
                if (logger.isErrorEnabled()) {
                    logger.debug("Found bean property '{}' of type [{}]; editor [{}]", new Object[]{pd.getName(), pd.getPropertyType(), pd.getPropertyEditorClass()});
                }
                pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
            for (Class<?> clazz = beanClass; clazz != null; clazz = clazz.getSuperclass()) {
                Class<?>[] ifcs;
                for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                    PropertyDescriptor[] ifcPds;
                    BeanInfo ifcInfo = Introspector.getBeanInfo(ifc, 3);
                    for (PropertyDescriptor pd : ifcPds = ifcInfo.getPropertyDescriptors()) {
                        if (this.propertyDescriptorCache.containsKey(pd.getName())) continue;
                        pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                        this.propertyDescriptorCache.put(pd.getName(), pd);
                    }
                }
            }
            this.typeDescriptorCache = new ConcurrentReferenceHashMap<PropertyDescriptor, TypeDescriptor>();
        }
        catch (IntrospectionException ex) {
            throw new BeansException("Failed to obtain BeanInfo for class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class<?> getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && Strings.isNotEmpty(name) && (pd = this.propertyDescriptorCache.get(Strings.uncapitalize(name))) == null) {
            pd = this.propertyDescriptorCache.get(Strings.capitalize(name));
        }
        return pd == null || pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        for (PropertyDescriptor pd : this.propertyDescriptorCache.values()) {
            pds[i] = pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
            ++i;
        }
        return pds;
    }

    private PropertyDescriptor buildGenericTypeAwarePropertyDescriptor(Class<?> beanClass, PropertyDescriptor pd) {
        try {
            return new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
        }
        catch (IntrospectionException ex) {
            throw new BeansException("Failed to re-introspect class [" + beanClass.getName() + "]", ex);
        }
    }

    TypeDescriptor addTypeDescriptor(PropertyDescriptor pd, TypeDescriptor td) {
        TypeDescriptor existing = this.typeDescriptorCache.putIfAbsent(pd, td);
        return existing != null ? existing : td;
    }

    TypeDescriptor getTypeDescriptor(PropertyDescriptor pd) {
        return (TypeDescriptor)this.typeDescriptorCache.get(pd);
    }
}

