/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.cache.BaseCache;
import com.jn.langx.cache.Entry;
import com.jn.langx.cache.Loader;
import com.jn.langx.cache.RemoveCause;
import com.jn.langx.cache.RemoveListener;
import com.jn.langx.util.Dates;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.collection.WrappedNonAbsentMap;
import com.jn.langx.util.collection.iter.EnumerationIterable;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public abstract class AbstractCache<K, V>
extends BaseCache<K, V> {
    private ConcurrentReferenceHashMap<K, Entry<K, V>> map;
    private Loader<K, V> globalLoader;
    private long expireAfterWrite = -1L;
    private long expireAfterRead = -1L;
    private long refreshAfterAccess = -1L;
    private RemoveListener<K, V> removeListener;
    private int maxCapacity;
    private float capacityHeightWater = 0.95f;
    private ReferenceType keyReferenceType;
    private ReferenceType valueReferenceType;
    private ReferenceQueue referenceQueue;
    private Map<Long, List<K>> expireTimeIndex = WrappedNonAbsentMap.wrap(new TreeMap(new ComparableComparator()), new Supplier<Long, List<K>>(){

        @Override
        public List<K> get(Long expireTime) {
            return Collects.emptyLinkedList();
        }
    });
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    protected AbstractCache(int maxCapacity, long evictExpiredInterval) {
        this(maxCapacity, evictExpiredInterval, null);
    }

    protected AbstractCache(int maxCapacity, long evictExpiredInterval, Timer timer) {
        this(maxCapacity, evictExpiredInterval, 0L, timer);
    }

    protected AbstractCache(int maxCapacity, long evictExpiredInterval, long refreshAllInterval, Timer timer) {
        this.evictExpiredInterval = evictExpiredInterval;
        this.refreshAllInterval = refreshAllInterval;
        Preconditions.checkTrue(evictExpiredInterval >= 0L);
        this.maxCapacity = maxCapacity;
        this.computeNextEvictExpiredTime();
        this.computeNextRefreshAllTime();
        this.timer = timer;
    }

    public void setKeyReferenceType(ReferenceType keyReferenceType) {
        this.keyReferenceType = keyReferenceType;
    }

    public void setValueReferenceType(ReferenceType valueReferenceType) {
        this.valueReferenceType = valueReferenceType;
    }

    public void setReferenceQueue(ReferenceQueue referenceQueue) {
        this.referenceQueue = referenceQueue;
    }

    @Override
    public void set(@NonNull K key, @Nullable V value) {
        this.set(key, value, this.expireAfterWrite, TimeUnit.SECONDS);
    }

    @Override
    public void set(@NonNull K key, @Nullable V value, long duration, TimeUnit timeUnit) {
        if (duration >= 0L) {
            duration = timeUnit.toMillis(duration);
        }
        this.set(key, value, Dates.nextTime(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@NonNull K key, @Nullable V value, long expire) {
        Preconditions.checkNotNull(key);
        Preconditions.checkTrue(expire > 0L);
        if (!this.running) {
            return;
        }
        this.evictExpired();
        long now = System.currentTimeMillis();
        if (value == null) {
            this.remove(key, RemoveCause.EXPLICIT);
        } else if (expire < now) {
            this.remove(key, RemoveCause.EXPIRED);
        } else {
            this.writeLock.lock();
            try {
                this.remove(key, RemoveCause.REPLACED);
                Entry<K, V> entry = new Entry<K, V>(key, this.keyReferenceType, value, this.valueReferenceType, this.referenceQueue, false, expire);
                this.map.put(key, entry);
                this.expireTimeIndex.get(entry.getExpireTime()).add(entry.getKey());
                this.addToCache(entry);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected abstract void addToCache(Entry<K, V> var1);

    protected void incrementUsedCount(Entry<K, V> entry) {
        entry.incrementUseCount();
        entry.incrementAge();
    }

    @Override
    public V get(@NonNull K key) {
        return this.get(key, null);
    }

    @Override
    public Map<K, V> getAll(Iterable<K> keys) {
        final HashMap m = new HashMap();
        Collects.forEach(keys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                Object v = AbstractCache.this.get(key);
                m.put(key, v);
            }
        });
        return m;
    }

    @Override
    public Map<K, V> getAllIfPresent(Iterable<K> keys) {
        final HashMap amap = new HashMap();
        Collects.forEach(keys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                Object v = AbstractCache.this.getIfPresent(key);
                amap.put(key, v);
            }
        });
        return amap;
    }

    @Override
    public V getIfPresent(@NonNull K key) {
        return this.get(key, null, false);
    }

    @Override
    public V get(@NonNull K key, @Nullable Supplier<K, V> loader) {
        return this.get(key, loader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V get(@NonNull K key, @Nullable Supplier<K, V> loader, boolean loadIfAbsent) {
        if (!this.running) {
            return null;
        }
        this.evictExpired();
        Entry<K, V> entry = this.map.get(key);
        if (entry != null) {
            if (!entry.isExpired()) {
                if (this.refreshAfterAccess > 0L) {
                    long nextRefreshTime = Dates.nextTime(entry.getLastUsedTime(), TimeUnit.SECONDS.toMillis(this.refreshAfterAccess));
                    if (System.currentTimeMillis() > nextRefreshTime) {
                        return this.refresh(key, true);
                    }
                }
                this.incrementUsedCount(entry);
                if (this.expireAfterRead > 0L) {
                    this.writeLock.lock();
                    try {
                        Object key0 = entry.getKey();
                        if (key0 != null) {
                            this.expireTimeIndex.get(entry.getExpireTime()).remove(key0);
                            this.beforeRecomputeExpireTimeOnRead(entry);
                            entry.setExpireTime(Dates.nextTime(TimeUnit.SECONDS.toMillis(this.expireAfterRead)));
                            this.expireTimeIndex.get(entry.getExpireTime()).add(key0);
                            this.afterRecomputeExpireTimeOnRead(entry);
                        }
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                V v = null;
                this.beforeRead(entry);
                v = entry.getValue();
                this.afterRead(entry);
                return v;
            }
            this.remove(key, RemoveCause.EXPIRED);
        }
        V value = null;
        if (loadIfAbsent) {
            Logger logger = Loggers.getLogger(this.getClass());
            String errorMessage = "Error occur when load resource for key: {}, error message: {}, stack:";
            if (loader != null) {
                try {
                    value = loader.get(key);
                }
                catch (Exception ex) {
                    logger.warn(errorMessage, new Object[]{key, ex.getMessage(), ex});
                }
            } else {
                Holder<Exception> exceptionHolder = new Holder<Exception>();
                value = this.loadByGlobalLoader(key, exceptionHolder);
                if (value == null) {
                    if (exceptionHolder.get() != null) {
                        logger.warn(errorMessage, new Object[]{key, exceptionHolder.get().getMessage(), exceptionHolder.get()});
                    } else {
                        this.remove(key, RemoveCause.REPLACED);
                    }
                }
            }
            if (value != null) {
                this.set(key, value);
            }
        }
        if ((entry = this.map.get(key)) != null) {
            entry.incrementUseCount();
            try {
                this.writeLock.lock();
                this.afterRecomputeExpireTimeOnRead(entry);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return value;
    }

    protected abstract void beforeRecomputeExpireTimeOnRead(Entry<K, V> var1);

    protected abstract void afterRecomputeExpireTimeOnRead(Entry<K, V> var1);

    @Override
    public void refresh(@NonNull K key) {
        this.refresh(key, false);
    }

    private V refresh(@NonNull K key, boolean internalInvoke) {
        if (!this.running) {
            return null;
        }
        Preconditions.checkNotNull(key);
        Holder<Exception> exceptionHolder = new Holder<Exception>();
        V value = this.loadByGlobalLoader(key, exceptionHolder);
        if (value == null) {
            if (exceptionHolder.get() != null) {
                Logger logger = Loggers.getLogger(this.getClass());
                logger.warn("Error occur when load resource for key: {}, error message: {}, stack:", new Object[]{key, exceptionHolder.get().getMessage(), exceptionHolder.get()});
            } else {
                this.remove(key, internalInvoke ? RemoveCause.REPLACED : RemoveCause.EXPLICIT);
            }
        } else {
            this.set(key, value);
        }
        return this.get(key);
    }

    @Override
    protected void refreshAllAsync(final @Nullable Timeout timeout) {
        Set<K> keys = this.keys();
        Collects.forEach(keys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                if (AbstractCache.this.timer != null) {
                    AbstractCache.this.timer.newTimeout(new BaseCache.RefreshKeyTask(AbstractCache.this, key), 1L, TimeUnit.MILLISECONDS);
                } else {
                    AbstractCache.this.refresh(key);
                }
            }
        }, new Predicate<K>(){

            @Override
            public boolean test(K key) {
                return timeout != null && timeout.isCancelled();
            }
        });
    }

    private V loadByGlobalLoader(@NonNull K key, @NonNull Holder<Exception> error) {
        V value = null;
        if (this.globalLoader != null) {
            try {
                value = this.globalLoader.load(key);
            }
            catch (Exception ex) {
                error.set(ex);
            }
        }
        return value;
    }

    protected abstract void removeFromCache(Entry<K, V> var1, RemoveCause var2);

    protected abstract void beforeRead(Entry<K, V> var1);

    protected abstract void afterRead(Entry<K, V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final V remove(@NonNull K key, @NonNull RemoveCause cause) {
        Object ret = null;
        this.writeLock.lock();
        try {
            Entry<K, V> entry = this.map.remove(key);
            if (entry != null) {
                this.expireTimeIndex.get(entry.getExpireTime()).remove(entry.getKey());
                ret = entry.getValue(false);
            }
            if (ret != null) {
                this.removeFromCache(entry, cause);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (ret != null && this.removeListener != null) {
            this.removeListener.onRemove(key, ret, cause);
        }
        return ret;
    }

    @Override
    public V remove(@NonNull K key) {
        this.evictExpired();
        return this.remove(key, RemoveCause.EXPLICIT);
    }

    @Override
    public List<V> remove(Collection<K> keys) {
        final List list = Collects.emptyArrayList();
        Collects.forEach(keys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                Object v = AbstractCache.this.remove(key);
                list.add(v);
            }
        });
        return list;
    }

    @Override
    public void evictExpired() {
        if (this.evictExpiredInterval >= 0L && System.currentTimeMillis() >= this.nextEvictExpiredTime || (float)this.map.size() > (float)this.maxCapacity * this.capacityHeightWater) {
            this.clearExpired();
            int forceEvictCount = this.map.size() - Numbers.toInt(Float.valueOf((float)this.maxCapacity * this.capacityHeightWater));
            if (forceEvictCount > 0) {
                this.writeLock.lock();
                try {
                    List<K> cleared = this.forceEvict(forceEvictCount);
                    Collects.forEach(cleared, new Consumer<K>(){

                        @Override
                        public void accept(K key) {
                            AbstractCache.this.remove(key, RemoveCause.REPLACED);
                        }
                    });
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            Collects.forEach(this.map, new Consumer2<K, Entry<K, V>>(){

                @Override
                public void accept(K key, Entry<K, V> entry) {
                    entry.incrementAge();
                }
            });
        }
    }

    protected abstract List<K> forceEvict(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExpired() {
        long now = System.currentTimeMillis();
        this.writeLock.lock();
        try {
            ArrayList<Long> expireTimes = new ArrayList<Long>(this.expireTimeIndex.keySet());
            for (Long expireTime : expireTimes) {
                if (expireTime > now) {
                    break;
                }
                ArrayList keys = new ArrayList(this.expireTimeIndex.get(expireTime));
                this.expireTimeIndex.remove(expireTime);
                Collects.forEach(keys, new Consumer2<Integer, K>(){

                    @Override
                    public void accept(Integer expireTime, K key) {
                        AbstractCache.this.remove(key, RemoveCause.EXPIRED);
                    }
                });
            }
        }
        finally {
            this.computeNextEvictExpiredTime();
            this.writeLock.unlock();
        }
    }

    @Override
    public void clean() {
        this.map.clear();
    }

    @Override
    public int size() {
        this.evictExpired();
        return this.map.size();
    }

    @Override
    public Set<K> keys() {
        return Collects.asSet(new EnumerationIterable<K>(this.map.keys()));
    }

    @Override
    public Map<K, V> toMap() {
        final HashMap m = new HashMap();
        Collects.forEach(this.map, new Consumer2<K, Entry<K, V>>(){

            @Override
            public void accept(K key, Entry<K, V> entry) {
                m.put(key, entry.getValue(false));
            }
        });
        return m;
    }

    protected void setMap(ConcurrentReferenceHashMap<K, Entry<K, V>> map) {
        this.map = map;
    }

    protected void setGlobalLoader(Loader<K, V> globalLoader) {
        this.globalLoader = globalLoader;
    }

    protected void setExpireAfterWrite(long expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    protected void setExpireAfterRead(long expireAfterRead) {
        this.expireAfterRead = expireAfterRead;
    }

    protected void setEvictExpiredInterval(long evictExpiredInterval) {
        this.evictExpiredInterval = evictExpiredInterval;
    }

    protected void setRemoveListener(RemoveListener<K, V> removeListener) {
        this.removeListener = removeListener;
    }

    protected void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    protected void setCapacityHeightWater(float capacityHeightWater) {
        this.capacityHeightWater = capacityHeightWater;
    }

    protected void setRefreshAfterAccess(long refreshAfterAccess) {
        this.refreshAfterAccess = refreshAfterAccess;
    }

    protected void setRefreshAllInterval(long refreshAllInterval) {
        this.refreshAllInterval = refreshAllInterval;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

