/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.cache.Cache;
import com.jn.langx.lifecycle.Lifecycle;
import com.jn.langx.util.Dates;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.CommonThreadFactory;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class BaseCache<K, V>
implements Cache<K, V>,
Lifecycle {
    protected volatile long evictExpiredInterval;
    protected volatile long nextEvictExpiredTime;
    protected volatile long nextRefreshAllTime;
    protected volatile long refreshAllInterval;
    protected Holder<Timeout> refreshAllTimeoutHolder = new Holder();
    protected Timer timer;
    private boolean shutdownTimerSelf = false;
    protected volatile boolean running = false;
    private boolean distinctWhenRefresh = false;

    public void setDistinctWhenRefresh(boolean distinctWhenRefresh) {
        this.distinctWhenRefresh = distinctWhenRefresh;
    }

    void computeNextEvictExpiredTime() {
        this.nextEvictExpiredTime = this.evictExpiredInterval < 0L ? Long.MAX_VALUE : Dates.nextTime(this.evictExpiredInterval);
    }

    void computeNextRefreshAllTime() {
        this.computeNextRefreshAllTime(this.refreshAllInterval);
    }

    void computeNextRefreshAllTime(long refreshAllInterval) {
        this.nextRefreshAllTime = refreshAllInterval < 0L ? Long.MAX_VALUE : Dates.nextTime(refreshAllInterval);
    }

    Timeout createRefreshAllTask(int delaySeconds, boolean fixedRate) {
        long delayMills = TimeUnit.SECONDS.toMillis(delaySeconds);
        Timeout timeout = this.timer.newTimeout(new RefreshAllTask(fixedRate, delayMills), delayMills, TimeUnit.MILLISECONDS);
        return timeout;
    }

    @Override
    public void refreshAllAsync(int delay, boolean fixed) {
        Preconditions.checkNotNull(this.timer, "");
        if (fixed) {
            Preconditions.checkTrue(delay > 0);
        }
        delay = Maths.max(delay, 0);
        if (!fixed && delay == 0) {
            this.refreshAllAsync(null);
        } else {
            Timeout timeout = this.createRefreshAllTask(delay, fixed);
            if (fixed) {
                this.refreshAllTimeoutHolder.set(timeout);
            }
        }
    }

    protected void refreshAllAsync(final @Nullable Timeout timeout) {
        Set keys = this.keys();
        Collects.forEach(keys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                if (BaseCache.this.timer != null) {
                    BaseCache.this.timer.newTimeout(new RefreshKeyTask(key), 1L, TimeUnit.MILLISECONDS);
                } else {
                    BaseCache.this.refresh(key);
                }
            }
        }, new Predicate<K>(){

            @Override
            public boolean test(K key) {
                return timeout != null && timeout.isCancelled();
            }
        });
    }

    @Override
    public void cancelRefreshAll() {
        if (!this.refreshAllTimeoutHolder.isEmpty()) {
            Timeout timeout = this.refreshAllTimeoutHolder.get();
            timeout.cancel();
        }
    }

    @Override
    public void startup() {
        if (!this.running) {
            this.running = true;
            this.computeNextEvictExpiredTime();
            this.computeNextRefreshAllTime();
            if ((this.evictExpiredInterval > 0L || this.refreshAllInterval > 0L) && this.timer == null) {
                this.timer = new HashedWheelTimer(new CommonThreadFactory("Cache-Evict", false));
                this.shutdownTimerSelf = true;
            }
            if (this.evictExpiredInterval > 0L) {
                this.timer.newTimeout(new EvictExpiredTask(), this.nextEvictExpiredTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            if (this.refreshAllInterval > 0L) {
                this.refreshAllTimeoutHolder.set(this.timer.newTimeout(new RefreshAllTask(true, this.refreshAllInterval), this.refreshAllInterval, TimeUnit.MILLISECONDS));
            }
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
        if (this.timer != null && this.shutdownTimerSelf) {
            this.timer.stop();
        }
    }

    class EvictExpiredTask
    implements TimerTask {
        EvictExpiredTask() {
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (!timeout.isCancelled()) {
                try {
                    BaseCache.this.evictExpired();
                }
                catch (Throwable ex) {
                    Loggers.getLogger(this.getClass()).warn(ex.getMessage(), ex);
                }
                BaseCache.this.timer.newTimeout(this, BaseCache.this.nextEvictExpiredTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    class RefreshKeyTask
    implements TimerTask {
        private K key;

        RefreshKeyTask(K key) {
            this.key = key;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (!timeout.isCancelled()) {
                BaseCache.this.refresh(this.key);
            }
        }

        public boolean equals(Object obj) {
            if (!BaseCache.this.distinctWhenRefresh) {
                return false;
            }
            if (obj == this.key) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != RefreshKeyTask.class && !Reflects.isSubClassOrEquals(RefreshKeyTask.class, obj.getClass())) {
                return false;
            }
            RefreshKeyTask that = (RefreshKeyTask)obj;
            if (!Reflects.isSubClassOrEquals(this.key.getClass(), that.key.getClass())) {
                return false;
            }
            return Objs.equals(that.key, this.key);
        }

        public int hashCode() {
            return Objs.hash(this.key);
        }
    }

    class RefreshAllTask
    implements TimerTask {
        private boolean fixedRate;
        private long delayInMills;

        public RefreshAllTask(boolean fixedRate, long delayInMills) {
            this.fixedRate = fixedRate;
            this.delayInMills = delayInMills;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (!timeout.isCancelled()) {
                BaseCache.this.refreshAllAsync(timeout);
                BaseCache.this.computeNextRefreshAllTime(this.delayInMills);
                if (this.fixedRate && !timeout.isCancelled()) {
                    BaseCache.this.refreshAllTimeoutHolder.set(BaseCache.this.timer.newTimeout(this, BaseCache.this.nextRefreshAllTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
                }
            }
        }
    }
}

