/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.cache.AbstractCache;
import com.jn.langx.cache.Cache;
import com.jn.langx.cache.LRUCache;
import com.jn.langx.cache.Loader;
import com.jn.langx.cache.RemoveListener;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timer;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeUnit;

public class CacheBuilder<K, V> {
    private Class cacheClass = LRUCache.class;
    private int concurrencyLevel = Platform.cpuCore();
    private int initialCapacity;
    private Loader<K, V> loader;
    private long expireAfterWrite = -1L;
    private long expireAfterRead = -1L;
    private long refreshAfterAccess = Long.MAX_VALUE;
    private long refreshAllInterval = TimeUnit.HOURS.toMillis(1L);
    private long evictExpiredInterval = 300000L;
    private RemoveListener<K, V> removeListener;
    private int maxCapacity = Integer.MAX_VALUE;
    private Timer timer;
    private float capacityHeightWater = 0.95f;
    private boolean distinctWhenRefresh = false;
    private ReferenceType keyReferenceType = ReferenceType.STRONG;
    private ReferenceType valueReferenceType = ReferenceType.STRONG;

    private CacheBuilder() {
    }

    public static <K, V> CacheBuilder<K, V> newBuilder() {
        return new CacheBuilder<K, V>();
    }

    public CacheBuilder<K, V> cacheClass(Class cacheClass) {
        this.cacheClass = cacheClass;
        return this;
    }

    public CacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    public CacheBuilder<K, V> initialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public CacheBuilder<K, V> loader(Loader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    public CacheBuilder<K, V> expireAfterWrite(long expireAfterWriteInSeconds) {
        this.expireAfterWrite = expireAfterWriteInSeconds;
        return this;
    }

    public CacheBuilder<K, V> expireAfterRead(long expireAfterReadInSeconds) {
        this.expireAfterRead = expireAfterReadInSeconds;
        return this;
    }

    @Deprecated
    public CacheBuilder<K, V> evictExpiredInterval(long evictExpiredIntervalInMills, Timer timer) {
        return this.evictExpiredInterval(evictExpiredIntervalInMills).timer(timer);
    }

    public CacheBuilder<K, V> evictExpiredInterval(long evictExpiredIntervalInMills) {
        this.evictExpiredInterval = evictExpiredIntervalInMills;
        return this;
    }

    public CacheBuilder<K, V> timer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public CacheBuilder<K, V> refreshAllInterval(long refreshIntervalInMills) {
        this.refreshAllInterval = refreshIntervalInMills;
        return this;
    }

    public CacheBuilder<K, V> distinctWhenRefresh(boolean distinctRefreshEnabled) {
        this.distinctWhenRefresh = distinctRefreshEnabled;
        return this;
    }

    public CacheBuilder<K, V> removeListener(RemoveListener<K, V> removeListener) {
        this.removeListener = removeListener;
        return this;
    }

    public CacheBuilder<K, V> maxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        return this;
    }

    public CacheBuilder<K, V> capacityHeightWater(float capatityHeightWater) {
        this.capacityHeightWater = capatityHeightWater;
        return this;
    }

    public CacheBuilder<K, V> refreshAfterAccess(long refreshAfterAccess) {
        this.refreshAfterAccess = refreshAfterAccess;
        return this;
    }

    public CacheBuilder<K, V> weakValue(boolean weakValue) {
        if (weakValue) {
            this.valueReferenceType = ReferenceType.WEAK;
        }
        return this;
    }

    public CacheBuilder<K, V> softValue(boolean softValue) {
        if (softValue) {
            this.valueReferenceType = ReferenceType.SOFT;
        }
        return this;
    }

    public CacheBuilder<K, V> weakKey(boolean weakKey) {
        if (weakKey) {
            this.keyReferenceType = ReferenceType.WEAK;
        }
        return this;
    }

    public CacheBuilder<K, V> softKey(boolean softKey) {
        if (softKey) {
            this.keyReferenceType = ReferenceType.SOFT;
        }
        return this;
    }

    public Cache<K, V> build() {
        Preconditions.checkNotNull(this.cacheClass, "Please specify your cache class");
        Preconditions.checkTrue(Reflects.isSubClass(AbstractCache.class, this.cacheClass), StringTemplates.formatWithPlaceholder("Your cache calss {} is not a subclass of {}", Reflects.getFQNClassName(this.cacheClass), Reflects.getFQNClassName(AbstractCache.class)));
        AbstractCache cache = (AbstractCache)Reflects.newInstance(this.cacheClass);
        Preconditions.checkNotNull(cache);
        cache.setExpireAfterRead(this.expireAfterRead);
        cache.setExpireAfterWrite(this.expireAfterWrite);
        cache.setRefreshAfterAccess(this.refreshAfterAccess < 0L ? Long.MAX_VALUE : this.refreshAfterAccess);
        cache.setGlobalLoader(this.loader);
        cache.setMaxCapacity(this.maxCapacity < 0 ? Integer.MAX_VALUE : this.maxCapacity);
        cache.setEvictExpiredInterval(this.evictExpiredInterval < 0L ? Long.MAX_VALUE : this.evictExpiredInterval);
        cache.setRefreshAllInterval(this.refreshAllInterval);
        cache.setDistinctWhenRefresh(this.distinctWhenRefresh);
        cache.setCapacityHeightWater(this.capacityHeightWater <= 0.0f ? 0.95f : this.capacityHeightWater);
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap(this.initialCapacity, 16.0f, this.concurrencyLevel, this.keyReferenceType, ReferenceType.STRONG);
        cache.setKeyReferenceType(this.keyReferenceType);
        cache.setValueReferenceType(this.valueReferenceType);
        if (this.keyReferenceType != ReferenceType.STRONG || this.valueReferenceType != ReferenceType.STRONG) {
            cache.setReferenceQueue(new ReferenceQueue());
        }
        cache.setMap(map);
        cache.setRemoveListener(this.removeListener);
        if (this.evictExpiredInterval > 0L || this.refreshAllInterval > 0L || this.timer != null) {
            if (this.refreshAllInterval > 0L && this.distinctWhenRefresh && this.timer instanceof HashedWheelTimer) {
                Preconditions.checkArgument(this.timer.isDistinctSupported(), "not a distinct supported timer, use the DistinctHashedWheelTimeoutFactory.class when create the timer");
            }
            cache.setTimer(this.timer);
        }
        cache.startup();
        return cache;
    }
}

