/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.cp;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.classpath.Classpaths;
import com.jn.langx.classpath.cp.AbstractClasspath;
import com.jn.langx.io.resource.DirectoryBasedFileResourceLoader;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.file.Files;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;

public class DirectoryClasspath
extends AbstractClasspath {
    private DirectoryBasedFileResourceLoader loader;
    private Location root;

    public DirectoryClasspath(String rootDirectory) {
        this.root = new Location("file:", rootDirectory, "/");
        this.loader = new DirectoryBasedFileResourceLoader(rootDirectory);
    }

    @Override
    public Resource findResource(String relativePath) {
        relativePath = Classpaths.getCanonicalFilePath(relativePath);
        return this.loader.loadResource(relativePath);
    }

    @Override
    public Location getRoot() {
        return this.root;
    }

    @Override
    public Set<Location> allResources() {
        File rootFile = new File(this.root.getPath());
        TreeSet<Location> locations = Collects.emptyTreeSet();
        if (rootFile.exists() && rootFile.isDirectory()) {
            this.scan(locations, rootFile);
        }
        return locations;
    }

    private void scan(final @NonNull Set<Location> results, @NonNull File current) {
        if (current.isFile()) {
            results.add(new Location("file:", Files.getCanonicalPath(current)));
        } else {
            Collects.forEach(current.listFiles(), new Consumer<File>(){

                @Override
                public void accept(File file) {
                    DirectoryClasspath.this.scan(results, file);
                }
            });
        }
    }
}

