/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.codec.base58;

import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.io.bytes.Bytes;
import java.math.BigInteger;

public class Base58 {
    private static final BigInteger BASE = BigInteger.valueOf(58L);
    private static final int BLOCK_LENGTH_BYTES = 29;
    private static final int BLOCK_LENGTH_DIGITS = 128;
    private static final char[] ALPHABET = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String encodeToString(byte[] source) {
        BigInteger dividend;
        if (source.length == 0) {
            return "";
        }
        if (source[0] >= 0) {
            dividend = new BigInteger(source);
        } else {
            byte[] paddedSource = new byte[source.length + 1];
            System.arraycopy(source, 0, paddedSource, 1, source.length);
            dividend = new BigInteger(paddedSource);
        }
        if (dividend.equals(BigInteger.ZERO)) {
            return "1";
        }
        StringBuilder sb = new StringBuilder();
        while (dividend.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] qr = dividend.divideAndRemainder(BASE);
            int base58DigitValue = qr[1].intValue();
            sb.append(ALPHABET[base58DigitValue]);
            dividend = qr[0];
        }
        return sb.reverse().toString();
    }

    public String encode(byte[] source) {
        return Base58.encodeToString(source);
    }

    public static String encodeToString(long value) {
        byte[] bs = Bytes.toBytes(value);
        return Base58.encodeToString(bs);
    }

    public String encode(long value) {
        return Base58.encodeToString(value);
    }

    public static byte[] decodeString(String source) {
        BigInteger value = BigInteger.ZERO;
        for (int i = 0; i < source.length(); ++i) {
            value = value.add(BigInteger.valueOf(PrimitiveArrays.indexOf(ALPHABET, source.charAt(i), 0)));
            value = value.multiply(BASE);
        }
        return value.toByteArray();
    }

    public byte[] decode(String source) {
        return Base58.decodeString(source);
    }

    public static byte[] doDecode(String source, int numBytes) {
        return Base58.padToSize(Base58.decodeString(source), numBytes);
    }

    public byte[] decode(String source, int numBytes) {
        return Base58.doDecode(source, numBytes);
    }

    private static byte[] padToSize(byte[] array, int size) {
        if (size == array.length) {
            return array;
        }
        if (size > array.length) {
            byte[] target = new byte[size];
            System.arraycopy(array, 0, target, size - array.length, array.length);
            return target;
        }
        for (int i = 0; i < array.length - size; ++i) {
            if (array[i] == 0) continue;
            throw new IllegalArgumentException("requested size " + size + " is shorter than existing length " + array.length + " and the leading bytes are not zeroes");
        }
        byte[] target = new byte[size];
        System.arraycopy(array, array.length - size, target, 0, size);
        return target;
    }
}

