/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NullableIf;
import com.jn.langx.cache.Cache;
import com.jn.langx.configuration.BaseConfigurationRepository;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationEventType;
import com.jn.langx.configuration.ConfigurationLoader;
import com.jn.langx.configuration.ConfigurationWriter;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.CommonThreadFactory;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractConfigurationRepository<T extends Configuration, Loader extends ConfigurationLoader<T>, Writer extends ConfigurationWriter<T>>
extends BaseConfigurationRepository<T, Loader, Writer> {
    @NonNull
    protected Cache<String, T> cache;
    protected int reloadIntervalInSeconds = -1;
    @NullableIf(value="reloadIntervalInSeconds>0")
    private Timer timer;

    public void setReloadIntervalInSeconds(int reloadIntervalInSeconds) {
        this.reloadIntervalInSeconds = reloadIntervalInSeconds;
    }

    public void setCache(Cache<String, T> cache) {
        this.cache = cache;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    protected void doStart() {
        if (!this.inited) {
            this.init();
        }
        Preconditions.checkNotNull(this.cache);
        final Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Startup configuration repository: {}", (Object)this.getName());
        if (this.reloadIntervalInSeconds > 0) {
            try {
                this.reload();
            }
            catch (Throwable ex) {
                logger.warn(ex.getMessage(), ex);
            }
            if (this.timer == null) {
                logger.warn("The timer is not specified for the repository ({}) , will use a simple timer", (Object)this.getName());
                this.timer = new HashedWheelTimer(new CommonThreadFactory("Configuration", true), 50L, TimeUnit.MILLISECONDS);
            }
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    try {
                        AbstractConfigurationRepository.this.reload();
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage(), ex);
                    }
                    finally {
                        if (AbstractConfigurationRepository.this.isRunning()) {
                            AbstractConfigurationRepository.this.timer.newTimeout(this, (long)AbstractConfigurationRepository.this.reloadIntervalInSeconds, TimeUnit.SECONDS);
                        }
                    }
                }
            }, (long)this.reloadIntervalInSeconds, TimeUnit.SECONDS);
        } else {
            this.reload();
        }
    }

    @Override
    protected void doStop() {
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Shutdown configuration repository: {}", (Object)this.getName());
        this.cache.clean();
    }

    @Override
    public T getById(String id) {
        return (T)((Configuration)this.cache.get(id));
    }

    @Override
    public void removeById(String id, boolean sync) {
        Configuration configuration = (Configuration)this.cache.getIfPresent(id);
        if (configuration != null) {
            this.logMutation(ConfigurationEventType.REMOVE, configuration);
            if (sync && this.writer != null && this.writer.isSupportsRemove()) {
                this.writer.remove(id);
            }
            this.cache.remove(id);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
    }

    @Override
    public T add(T configuration, boolean sync) {
        if (this.isRunning()) {
            this.logMutation(ConfigurationEventType.ADD, configuration);
            if (sync && this.writer != null && this.writer.isSupportsWrite()) {
                this.writer.write(configuration);
            }
            this.cache.set(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
        return configuration;
    }

    @Override
    public void update(T configuration, boolean sync) {
        if (this.isRunning()) {
            this.logMutation(ConfigurationEventType.UPDATE, configuration);
            if (sync && this.writer != null && this.writer.isSupportsRewrite()) {
                this.writer.rewrite(configuration);
            }
            this.cache.set(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.UPDATE, configuration));
            }
        }
    }

    @Override
    protected void doInit() {
        Preconditions.checkNotNull(this.getName(), "Repository has no named");
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Initial configuration repository: {}", (Object)this.getName());
    }

    @Override
    public Map<String, T> getAll() {
        return Collects.immutableMap(this.cache.toMap());
    }
}

