/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.database;

import com.jn.langx.configuration.AbstractConfigurationRepository;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.database.DatabaseBasedConfigurationLoader;
import com.jn.langx.configuration.database.DatabaseBasedConfigurationWriter;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.comparator.Comparators;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Loggers;
import java.util.Map;
import org.slf4j.Logger;

public class DatabaseBasedConfigurationRepository<T extends Configuration>
extends AbstractConfigurationRepository<T, DatabaseBasedConfigurationLoader<T>, DatabaseBasedConfigurationWriter<T>> {
    @Override
    public void init() throws InitializationException {
        if (!this.inited) {
            super.init();
            Preconditions.checkNotNull(this.loader, "the configuration load is null");
            Logger logger = Loggers.getLogger(this.getClass());
            if (this.writer == null) {
                logger.warn("The writer is not specified for the repository ({}), will disable write configuration to storage", (Object)this.getName());
            }
            if (this.reloadIntervalInSeconds > 1) {
                logger.info("The configuration refresh task is disabled for repository: {}", (Object)this.getName());
            }
            this.inited = true;
        }
    }

    @Override
    public void reload() {
        Map newConfigs = ((DatabaseBasedConfigurationLoader)this.loader).loadAll();
        Map oldConfigs = this.getAll();
        MapDiffResult differResult = Collects.diff(oldConfigs, newConfigs, this.getComparator(), Comparators.STRING_COMPARATOR);
        if (differResult.hasDifference()) {
            Collects.forEach(differResult.getAdds(), new Consumer<T>(){

                @Override
                public void accept(T newConfig) {
                    DatabaseBasedConfigurationRepository.this.add(newConfig, false);
                }
            });
            Collects.forEach(differResult.getUpdates(), new Consumer<T>(){

                @Override
                public void accept(T t) {
                    DatabaseBasedConfigurationRepository.this.update(t, false);
                }
            });
            Collects.forEach(differResult.getRemoves(), new Consumer<T>(){

                @Override
                public void accept(T t) {
                    DatabaseBasedConfigurationRepository.this.removeById(t.getId());
                }
            });
        }
    }
}

