/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.event;

import com.jn.langx.NameAware;
import com.jn.langx.event.DomainEvent;
import com.jn.langx.event.EventDispatcher;
import com.jn.langx.event.EventListener;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.WrappedNonAbsentMap;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.struct.counter.AtomicIntegerCounter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommonEventPublisher
implements EventPublisher,
NameAware {
    private EventDispatcher dispatcher;
    private String name;
    protected static final AtomicIntegerCounter counter = new AtomicIntegerCounter(0);
    private WrappedNonAbsentMap<String, Set<EventListener>> listenerMap = Collects.wrapAsNonAbsentMap(new ConcurrentHashMap(), new Supplier<String, Set<EventListener>>(){

        @Override
        public Set<EventListener> get(String input) {
            return new LinkedHashSet<EventListener>();
        }
    });

    public EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public CommonEventPublisher() {
        this.setName("common");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void publish(DomainEvent event) {
        List<EventListener> listeners = this.getListeners(event.getDomain());
        this.getDispatcher().dispatch(event, listeners);
    }

    public void setDispatcher(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void addEventListener(String eventDomain, EventListener listener) {
        this.listenerMap.get(eventDomain).add(listener);
    }

    @Override
    public void addFirst(String eventDomain, EventListener listener) {
        Set<EventListener> listeners = this.listenerMap.get(eventDomain);
        List<EventListener> list = Collects.asList(listeners);
        list.add(listener);
        list.addAll(listeners);
        listeners = Collects.asSet(list);
        this.listenerMap.put(eventDomain, listeners);
    }

    @Override
    public void removeEventListener(String eventDomain, EventListener listener) {
        this.listenerMap.get(eventDomain).remove(listener);
    }

    @Override
    public List<EventListener> getListeners(String eventDomain) {
        return Collects.asList(this.listenerMap.get(eventDomain));
    }
}

