/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.buffer;

import com.jn.langx.io.buffer.CharSequenceBuffer;
import com.jn.langx.io.buffer.HeapCharBuffer;
import com.jn.langx.util.collection.buffer.Buffer;
import com.jn.langx.util.collection.buffer.exception.BufferOverflowException;
import com.jn.langx.util.collection.buffer.exception.BufferUnderflowException;
import com.jn.langx.util.collection.buffer.exception.ReadOnlyBufferException;
import java.io.IOException;

public abstract class CharBuffer<BF extends CharBuffer>
extends Buffer<BF>
implements Comparable<BF>,
Appendable,
CharSequence,
Readable {
    final char[] hb;
    final long offset;
    boolean isReadOnly;

    CharBuffer(long mark, long pos, long lim, long cap, char[] hb, long offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    CharBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0L);
    }

    public static CharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapCharBuffer(capacity, capacity);
    }

    public static CharBuffer wrap(char[] array, int offset, int length) {
        try {
            return new HeapCharBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(CharBuffer target) throws IOException {
        long targetRemaining = target.remaining();
        long remaining = this.remaining();
        if (remaining == 0L) {
            return -1L;
        }
        long n = Math.min(remaining, targetRemaining);
        long limit = this.limit();
        if (targetRemaining < remaining) {
            this.limit(this.position() + n);
        }
        try {
            if (n > 0L) {
                target.put(this);
            }
        }
        finally {
            this.limit(limit);
        }
        return n;
    }

    public static CharBuffer wrap(CharSequence csq, int start, int end) {
        try {
            return new CharSequenceBuffer(csq, start, end);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(CharSequence csq) {
        return CharBuffer.wrap(csq, 0, csq.length());
    }

    public abstract BF slice();

    public abstract CharBuffer duplicate();

    public abstract char get();

    public abstract BF put(char var1);

    public abstract char get(int var1);

    public char get(long index) {
        return this.get((int)index);
    }

    abstract char getUnchecked(int var1);

    @Override
    public int read(java.nio.CharBuffer cb) throws IOException {
        int length = 0;
        while (this.position() < this.limit()) {
            this.get();
            ++length;
        }
        return length;
    }

    public abstract CharBuffer put(int var1, char var2);

    public BF get(char[] dst, int offset, int length) {
        CharBuffer.checkBounds(offset, length, dst.length);
        if ((long)length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return (BF)this;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        long n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        int i = 0;
        while ((long)i < n) {
            this.put(src.get());
            ++i;
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        CharBuffer.checkBounds(offset, length, src.length);
        if ((long)length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public BF put(String src, long start, long end) {
        CharBuffer.checkBounds(start, end - start, src.length());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (end - start > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (long i = start; i < end; ++i) {
            this.put(src.charAt((int)i));
        }
        return (BF)this;
    }

    public final BF put(String src) {
        return this.put(src, 0L, (long)src.length());
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final char[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final long arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract BF compact();

    public abstract boolean isDirect();

    public int hashCode() {
        int h = 1;
        int p = (int)this.position();
        for (int i = (int)this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof CharBuffer)) {
            return false;
        }
        CharBuffer that = (CharBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        long p = this.position();
        long i = this.limit() - 1L;
        long j = that.limit() - 1L;
        while (i >= p) {
            if (!CharBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(char x, char y) {
        return x == y;
    }

    @Override
    public int compareTo(BF that) {
        long n = this.position() + Math.min(this.remaining(), ((Buffer)that).remaining());
        int i = (int)this.position();
        int j = (int)((Buffer)that).position();
        while ((long)i < n) {
            int cmp = CharBuffer.compare(this.get(i), ((CharBuffer)that).get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return (int)(this.remaining() - ((Buffer)that).remaining());
    }

    private static int compare(char x, char y) {
        return x - y;
    }

    @Override
    public String toString() {
        return this.substring(this.position(), this.limit());
    }

    public abstract String substring(long var1, long var3);

    @Override
    public final int length() {
        return (int)this.remaining();
    }

    @Override
    public final char charAt(int index) {
        return this.get(this.position() + this.checkIndex(index));
    }

    public abstract BF subSequence(int var1, int var2);

    public BF append(CharSequence csq) {
        if (csq == null) {
            return this.put("null");
        }
        return this.put(csq.toString());
    }

    public BF append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        return this.put(cs.subSequence(start, end).toString());
    }

    public BF append(char c) {
        return this.put(c);
    }
}

