/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.buffer;

import com.jn.langx.io.buffer.CharBuffer;
import com.jn.langx.util.collection.buffer.exception.ReadOnlyBufferException;

public class CharSequenceBuffer
extends CharBuffer<CharSequenceBuffer> {
    private CharSequence str;

    public CharSequenceBuffer(CharSequence s) {
        this(s, 0, s.length());
    }

    public CharSequenceBuffer(CharSequence s, int start, int end) {
        super(-1, start, end, s.length());
        int n = s.length();
        if (start < 0 || end < start || end > n) {
            throw new IndexOutOfBoundsException();
        }
        this.str = s;
    }

    @Override
    public CharSequenceBuffer slice() {
        return new CharSequenceBuffer(this.str, -1L, 0L, this.remaining(), this.remaining(), this.offset + this.position());
    }

    private CharSequenceBuffer(CharSequence s, long mark, long pos, long limit, long cap, long offset) {
        super(mark, pos, limit, cap, null, offset);
        this.str = s;
    }

    @Override
    public CharSequenceBuffer duplicate() {
        return new CharSequenceBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public final char get() {
        return this.str.charAt((int)(this.nextGetIndex() + this.offset));
    }

    @Override
    public final char get(int index) {
        return this.str.charAt((int)(this.checkIndex(index) + this.offset));
    }

    @Override
    char getUnchecked(int index) {
        return this.str.charAt((int)(this.checkIndex(index) + this.offset));
    }

    @Override
    public final CharSequenceBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharSequenceBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharSequenceBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final String substring(long start, long end) {
        return this.str.toString().substring((int)(start + this.offset), (int)(end + this.offset));
    }

    @Override
    public final CharSequenceBuffer subSequence(int start, int end) {
        try {
            long pos = this.position();
            return new CharSequenceBuffer(this.str, -1L, pos + this.checkIndex(start, pos), pos + this.checkIndex(end, pos), this.capacity(), this.offset);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean isDirect() {
        return false;
    }
}

