/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.buffer;

import com.jn.langx.io.buffer.CharBuffer;
import com.jn.langx.util.collection.buffer.exception.BufferOverflowException;
import com.jn.langx.util.collection.buffer.exception.BufferUnderflowException;

public class HeapCharBuffer
extends CharBuffer<HeapCharBuffer> {
    public HeapCharBuffer(int cap, int lim) {
        super(-1L, 0L, lim, cap, new char[cap], 0L);
    }

    public HeapCharBuffer(char[] buf, int off, int len) {
        super(-1L, off, off + len, buf.length, buf, 0L);
    }

    public HeapCharBuffer(char[] buf, long mark, long pos, long lim, long cap, long off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public HeapCharBuffer slice() {
        return new HeapCharBuffer(this.hb, -1L, 0L, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected long ix(long i) {
        return i + this.offset;
    }

    @Override
    public char get() {
        return this.hb[(int)this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int i) {
        return this.hb[(int)this.ix(this.checkIndex(i))];
    }

    @Override
    char getUnchecked(int i) {
        return this.hb[(int)this.ix(i)];
    }

    @Override
    public HeapCharBuffer get(char[] dst, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, dst.length);
        if ((long)length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, (int)this.ix(this.position()), dst, offset, length);
        this.position(this.position() + (long)length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public HeapCharBuffer put(char x) {
        this.hb[(int)this.ix((long)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public HeapCharBuffer put(int i, char x) {
        this.hb[(int)this.ix((long)this.checkIndex((long)((long)i)))] = x;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, src.length);
        if ((long)length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, (int)this.ix(this.position()), length);
        this.position(this.position() + (long)length);
        return this;
    }

    @Override
    public HeapCharBuffer put(CharBuffer src) {
        if (src instanceof HeapCharBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapCharBuffer sb = (HeapCharBuffer)src;
            long n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, (int)sb.ix(sb.position()), this.hb, (int)this.ix(this.position()), (int)n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            long n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, (int)this.ix(this.position()), (int)n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public HeapCharBuffer compact() {
        System.arraycopy(this.hb, (int)this.ix(this.position()), this.hb, (int)this.ix(0L), (int)this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public String substring(long start, long end) {
        try {
            return new String(this.hb, (int)(start + this.offset), (int)(end - start));
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public HeapCharBuffer subSequence(int start, int end) {
        if (start < 0 || end > this.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        long pos = this.position();
        return new HeapCharBuffer(this.hb, -1L, pos + (long)start, pos + (long)end, this.capacity(), this.offset);
    }
}

