/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.PathMatcher;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.pattern.patternset.AntPathMatcher;
import java.util.List;

public class GitIgnoreStylePathMatcher
implements PathMatcher {
    private AntPathMatcher matcher;
    private String paths;

    public GitIgnoreStylePathMatcher() {
    }

    public GitIgnoreStylePathMatcher(String pathsExpression) {
        this.setPaths(pathsExpression);
    }

    public void setPaths(String pathsExpression) {
        if (Strings.isBlank(pathsExpression)) {
            return;
        }
        this.paths = pathsExpression;
        String[] paths = Strings.split(pathsExpression, ";");
        final List antPaths = Collects.emptyArrayList();
        Collects.forEach(paths, new Consumer<String>(){

            @Override
            public void accept(String path) {
                boolean isDirectory = Strings.endsWith(path, "/");
                boolean notIgnoredMode = Strings.startsWith(path, "!");
                if (notIgnoredMode) {
                    path = Strings.substring(path, 1);
                }
                if (!Strings.startsWith(path, "/")) {
                    path = "**/" + path;
                }
                if (notIgnoredMode) {
                    path = "!" + path;
                }
                if (!Strings.startsWith(path, "/")) {
                    path = "/" + path;
                }
                if (isDirectory) {
                    String directory = Strings.substring(path, 0, path.length() - 1);
                    if (Strings.isNotEmpty(directory)) {
                        antPaths.add(directory);
                    }
                    antPaths.add(path + "**");
                } else {
                    antPaths.add(path);
                }
            }
        });
        String expression = Strings.join(";", antPaths);
        this.matcher = new AntPathMatcher();
        this.matcher.setGlobal(true);
        this.matcher.setPatternExpression(expression);
    }

    @Override
    public Boolean matches(String path) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.matches(path);
    }

    public String toString() {
        return "GitIgnoreStylePathMatcher{paths='" + this.paths + '\'' + '}';
    }

    public boolean matches(@NotEmpty String path, @Nullable String pathRoot) {
        if (Strings.isBlank(path)) {
            return false;
        }
        path = path.trim();
        if (pathRoot != null && Strings.startsWith(path, pathRoot)) {
            path = Strings.substring(path, pathRoot.length());
        }
        if (!Strings.startsWith(path = Strings.replace(path, "\\", "/"), "/")) {
            path = "/" + path;
        }
        if (Strings.isEmpty(path)) {
            return false;
        }
        boolean match = this.matches(path);
        return match;
    }
}

