/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.LineDelimiter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DelimiterBasedReadableByteChannel
implements ReadableByteChannel,
Iterable<byte[]> {
    private List<ByteBuffer> delimiters;
    private ReadableByteChannel channel;
    private ByteBuffer buf;
    private boolean eof = false;
    private int maxLengthOfDelimiters;
    private int minLengthOfDelimiters;

    public DelimiterBasedReadableByteChannel(ReadableByteChannel channel, String ... delimiter) {
        Preconditions.checkNotNull(channel, "channel is null");
        this.channel = channel;
        this.setDelimiters(delimiter);
    }

    public int read(ByteBuffer dst, String delimiter) throws IOException {
        this.setDelimiters(delimiter);
        return this.read(dst);
    }

    private void setDelimiters(String ... delimiters) {
        boolean hasLineDelimiter = Collects.anyMatch(new Predicate<String>(){

            @Override
            public boolean test(String delimiter) {
                return LineDelimiter.isLineDelimiter(delimiter);
            }
        }, delimiters);
        List<String> dels = Pipeline.of(delimiters).asList();
        if (hasLineDelimiter) {
            dels.addAll(LineDelimiter.supportedLineDelimiterStrings());
        }
        List<ByteBuffer> ds = Pipeline.of(dels).clearEmptys().distinct().sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        }).map(new Function<String, ByteBuffer>(){

            @Override
            public ByteBuffer apply(String delimiter) {
                return ByteBuffer.wrap(delimiter.getBytes(Charsets.UTF_8));
            }
        }).asList();
        Preconditions.checkTrue(Objs.isNotEmpty(ds), "delimiters is null or empty");
        this.delimiters = ds;
        this.maxLengthOfDelimiters = this.delimiters.get(0).limit();
        this.minLengthOfDelimiters = this.delimiters.get(this.delimiters.size() - 1).limit();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){

            @Override
            public boolean hasNext() {
                try {
                    return DelimiterBasedReadableByteChannel.this.hasNextSegment();
                }
                catch (IOException ex) {
                    return false;
                }
            }

            @Override
            public byte[] next() {
                if (this.hasNext()) {
                    try {
                        ByteBuffer byteBuffer = DelimiterBasedReadableByteChannel.this.nextSegment();
                        byte[] bytes = new byte[byteBuffer.remaining()];
                        byteBuffer.get(bytes);
                        return bytes;
                    }
                    catch (IOException ex) {
                        return Emptys.EMPTY_BYTES;
                    }
                }
                return Emptys.EMPTY_BYTES;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int fill() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.buf == null) {
            this.buf = ByteBuffer.allocate(256);
        } else if (this.buf.remaining() < Maths.max(this.maxLengthOfDelimiters, 1)) {
            if (this.buf.capacity() == this.buf.limit()) {
                int newBufCapacity = (double)this.buf.arrayOffset() > (double)this.buf.array().length * 0.8 ? this.buf.array().length : this.buf.array().length * 2;
                ByteBuffer buf2 = ByteBuffer.allocate(newBufCapacity);
                buf2.put(this.buf.array(), this.buf.arrayOffset(), this.buf.limit());
                this.buf = buf2;
            } else {
                this.buf.limit(this.buf.capacity());
            }
        }
        this.buf.mark();
        int length = this.channel.read(this.buf);
        if (length == -1) {
            this.eof = true;
        }
        this.buf.limit(this.buf.position());
        this.buf.reset();
        return length;
    }

    public boolean hasNextSegment() throws IOException {
        if (!(this.buf != null && this.buf.hasRemaining() || this.eof)) {
            this.fill();
        }
        return this.buf != null && (this.buf.hasRemaining() || !this.eof);
    }

    public ByteBuffer nextSegment() throws IOException {
        if (this.buf == null && this.eof) {
            return null;
        }
        if (this.buf == null || !this.buf.hasRemaining()) {
            this.fill();
            if (!this.buf.hasRemaining() && this.eof) {
                int start = this.buf.arrayOffset();
                ByteBuffer ret = ByteBuffer.wrap(this.buf.array(), start, this.buf.position());
                return ret;
            }
        }
        if (this.delimiters.size() > 1) {
            while (this.buf.hasRemaining() && this.buf.remaining() >= this.minLengthOfDelimiters) {
                Buffer delimiter = null;
                for (ByteBuffer del : this.delimiters) {
                    if (this.buf.remaining() < del.limit()) continue;
                    this.buf.mark();
                    byte[] tmp = new byte[del.limit()];
                    this.buf.get(tmp);
                    this.buf.reset();
                    if (!Objs.deepEquals(tmp, del.array())) continue;
                    delimiter = del;
                    break;
                }
                if (delimiter == null) {
                    this.buf.position(this.buf.position() + this.minLengthOfDelimiters);
                    continue;
                }
                int length = this.buf.position();
                int start = this.buf.arrayOffset();
                ByteBuffer ret = ByteBuffer.wrap(this.buf.array(), start, length);
                this.buf.position(this.buf.position() + delimiter.limit());
                this.buf = this.buf.slice();
                return ret;
            }
        } else {
            ByteBuffer delimiter = this.delimiters.get(0);
            delimiter.clear();
            byte firstByteOfDelimiter = delimiter.get();
            block2: while (this.buf.hasRemaining() && this.buf.remaining() >= delimiter.limit()) {
                if (this.buf.get() != firstByteOfDelimiter) continue;
                while (delimiter.hasRemaining() && this.buf.remaining() >= delimiter.remaining()) {
                    if (delimiter.get() == this.buf.get()) continue;
                    delimiter.clear();
                    firstByteOfDelimiter = delimiter.get();
                    continue block2;
                }
                delimiter.clear();
                int current = this.buf.position();
                int length = current - delimiter.limit();
                int start = this.buf.arrayOffset();
                ByteBuffer ret = ByteBuffer.wrap(this.buf.array(), start, length);
                this.buf = this.buf.slice();
                return ret;
            }
        }
        this.fill();
        return this.nextSegment();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

